/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.geo.WLCircle;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.api.geo.WLPolygon;
import com.worklight.location.internal.geo.AreaVisitor;

public class IsInsideAreaVisitor
implements AreaVisitor {
    private final WLCoordinate coordinate;
    private final WLConfidenceLevel confidence;
    private final double bufferZoneWidth;

    public IsInsideAreaVisitor(WLCoordinate coordinate, WLConfidenceLevel confidence, double bufferZoneWidth) {
        this.coordinate = coordinate;
        this.confidence = confidence;
        this.bufferZoneWidth = bufferZoneWidth;
    }

    @Override
    public Boolean visitCircle(WLCircle circle) {
        return WLGeoUtils.isInsideCircle(this.coordinate, circle, this.bufferZoneWidth, this.confidence);
    }

    @Override
    public Boolean visitPolygon(WLPolygon polygon) {
        return WLGeoUtils.isInsidePolygon(this.coordinate, polygon, this.bufferZoneWidth, this.confidence);
    }
}

