/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.geo.WLCircle;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.api.geo.WLPolygon;
import com.worklight.location.internal.geo.AreaVisitor;

public class GetDistanceToAreaVisitor
implements AreaVisitor {
    private final WLCoordinate coordinate;
    private final double bufferZoneWidth;

    public GetDistanceToAreaVisitor(WLCoordinate coordinate, double bufferZoneWidth) {
        this.coordinate = coordinate;
        this.bufferZoneWidth = bufferZoneWidth;
    }

    @Override
    public Double visitCircle(WLCircle circle) {
        return WLGeoUtils.getDistanceToCircle(this.coordinate, circle, this.bufferZoneWidth);
    }

    @Override
    public Double visitPolygon(WLPolygon polygon) {
        return WLGeoUtils.getDistanceToPolygon(this.coordinate, polygon, this.bufferZoneWidth);
    }
}

