/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoCallback;
import com.worklight.location.api.geo.WLGeoFailureCallback;
import com.worklight.location.internal.geo.GeoFactory;
import com.worklight.location.internal.geo.LocationHandler;

public class GeoAcquisitor {
    private LocationHandler watchHandler;
    private GeoFactory factory;

    public GeoAcquisitor(GeoFactory factory) {
        this.factory = factory;
    }

    public void acquirePosition(WLGeoCallback successCallback, WLGeoFailureCallback failureCallback, WLGeoAcquisitionPolicy policy) {
        this.createLocationHandler(successCallback, failureCallback, policy, false).start();
    }

    public void stopAcquisition() {
        if (this.watchHandler != null) {
            this.watchHandler.cancel();
            this.watchHandler = null;
        }
    }

    public void startAcquisition(WLGeoCallback successCallback, WLGeoFailureCallback errorCallback, WLGeoAcquisitionPolicy geoPolicy) {
        this.stopAcquisition();
        this.watchHandler = this.createLocationHandler(successCallback, errorCallback, geoPolicy, true);
        this.watchHandler.start();
    }

    protected LocationHandler createLocationHandler(WLGeoCallback successCallback, WLGeoFailureCallback errorCallback, WLGeoAcquisitionPolicy policy, boolean isWatchRequest) {
        return this.factory.createLocationHandler(successCallback, errorCallback, policy, isWatchRequest);
    }

    public boolean isAcquiring() {
        return this.watchHandler != null;
    }

    public WLGeoAcquisitionPolicy getWatchPolicy() {
        return this.isAcquiring() ? this.watchHandler.policy : null;
    }
}

