/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.WLDevice;
import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoCallback;
import com.worklight.location.api.geo.WLGeoFailureCallback;
import com.worklight.location.internal.geo.EmptyGeoCallback;

public class AcquireGeoPositionPseudoTimerTask
implements Runnable {
    private static WLGeoCallback emptySuccess = new EmptyGeoCallback();
    private WLDevice wlDevice;
    private WLGeoFailureCallback failureCallback;
    private WLGeoAcquisitionPolicy policy;
    private boolean cancelled = false;
    private long targetTime;

    public AcquireGeoPositionPseudoTimerTask(WLDevice wlDevice, WLGeoFailureCallback failureCallback, WLGeoAcquisitionPolicy policy, long delay) {
        this.wlDevice = wlDevice;
        this.failureCallback = failureCallback;
        this.policy = policy;
        this.targetTime = System.currentTimeMillis() + delay;
    }

    @Override
    public void run() {
        while (!this.cancelled()) {
            long now = System.currentTimeMillis();
            if (now >= this.targetTime) {
                this.wlDevice.acquireGeoPosition(emptySuccess, this.failureCallback, this.policy);
                return;
            }
            try {
                Thread.sleep(this.targetTime - now);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }
}

