/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events.storage;

import com.worklight.location.internal.events.storage.Chunk;
import com.worklight.location.internal.events.storage.IChunkStorage;
import java.util.ArrayList;
import java.util.List;

public class ChunkStorage
implements IChunkStorage {
    private long maxMemSize;
    private final IChunkStorage persistentStorage;
    private final List<Chunk> closedChunks = new ArrayList<Chunk>();
    private long currentMemSize;

    public ChunkStorage(long maximumMemorySize, IChunkStorage persistentStorage) {
        if (maximumMemorySize < 0L) {
            throw new IllegalArgumentException("Maximum memory size must be a positive integer: " + maximumMemorySize);
        }
        this.maxMemSize = maximumMemorySize;
        if (persistentStorage == null) {
            throw new IllegalArgumentException("persistentStorage is null");
        }
        this.persistentStorage = persistentStorage;
    }

    @Override
    public void store(Chunk c) {
        if (!this.persistentStorage.isEmpty() || this.currentMemSize + c.currentChunkSize() > this.maxMemSize) {
            this.persistentStorage.store(c);
        } else {
            this.closedChunks.add(c);
            this.currentMemSize += c.currentChunkSize();
        }
    }

    @Override
    public Chunk getFirst() {
        if (!this.closedChunks.isEmpty()) {
            return this.closedChunks.get(0);
        }
        return this.persistentStorage.getFirst();
    }

    @Override
    public void removeFirst() {
        if (!this.closedChunks.isEmpty()) {
            Chunk first = this.closedChunks.remove(0);
            this.currentMemSize -= first.currentChunkSize();
        } else {
            this.persistentStorage.removeFirst();
        }
        this.fillFromPersistentToMemory();
    }

    private void fillFromPersistentToMemory() {
        while (!this.persistentStorage.isEmpty()) {
            Chunk c = this.persistentStorage.getFirst();
            if (!this.closedChunks.isEmpty() && this.currentMemSize + c.currentChunkSize() > this.maxMemSize) {
                return;
            }
            this.closedChunks.add(c);
            this.persistentStorage.removeFirst();
            this.currentMemSize += c.currentChunkSize();
        }
    }

    @Override
    public void purgeAll() {
        this.closedChunks.clear();
        this.persistentStorage.purgeAll();
    }

    @Override
    public boolean isEmpty() {
        return this.closedChunks.isEmpty() && this.persistentStorage.isEmpty();
    }

    @Override
    public void setMaxmiumMemorySize(long maximumMemorySize) {
        if (maximumMemorySize < 0L) {
            throw new IllegalArgumentException("Maximum memory size must be a non-negative integer, received: " + maximumMemorySize);
        }
        this.maxMemSize = maximumMemorySize;
        if (this.currentMemSize > maximumMemorySize) {
            while (this.closedChunks.size() > 1) {
                Chunk c = this.closedChunks.remove(this.closedChunks.size() - 1);
                this.persistentStorage.store(c);
                this.currentMemSize -= c.currentChunkSize();
            }
        } else {
            this.fillFromPersistentToMemory();
        }
    }

    @Override
    public Chunk getChunk(long idx) {
        if (idx < 0L) {
            return null;
        }
        if (idx < (long)this.closedChunks.size()) {
            return this.closedChunks.get((int)idx);
        }
        return this.persistentStorage.getChunk(idx - (long)this.closedChunks.size());
    }

    @Override
    public long getNumChunks() {
        return (long)this.closedChunks.size() + this.persistentStorage.getNumChunks();
    }

    @Override
    public long getNumChunksPersisted() {
        return this.persistentStorage.getNumChunks();
    }

    public IChunkStorage forTestOnly_getPersistentStorage() {
        return this.persistentStorage;
    }
}

