/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events.storage;

import com.worklight.location.internal.nativeImpl.LocationUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Chunk {
    private final List<String> strings = new ArrayList<String>();
    private int size;
    private final long maxChunkSize;

    public Chunk(long chunkSize) {
        if (chunkSize < 0L) {
            throw new IllegalArgumentException("Chunk size can't be negative");
        }
        this.maxChunkSize = chunkSize;
    }

    public Chunk(JSONArray events, long chunkSize) throws JSONException {
        for (int i = 0; i < events.length(); ++i) {
            String s = events.getString(i);
            this.strings.add(s);
            this.size += LocationUtils.getByteLength(s);
        }
        this.maxChunkSize = chunkSize < 0L ? (long)this.size : chunkSize;
    }

    public long currentChunkSize() {
        return this.size;
    }

    public long maxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean add(JSONObject event) {
        String eventString = event.toString();
        int lengthInBytes = LocationUtils.getByteLength(eventString);
        if (this.size == 0 || (long)(this.size + lengthInBytes) < this.maxChunkSize) {
            this.size += lengthInBytes;
            this.strings.add(eventString);
            return true;
        }
        return false;
    }

    public JSONObject get(int i) {
        try {
            return new JSONObject(this.strings.get(i));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public int numberOfEvents() {
        return this.strings.size();
    }

    public Chunk createNewChunk() {
        return new Chunk(this.maxChunkSize);
    }

    List<String> getStrings() {
        return this.strings;
    }

    public Chunk createNewChunk(long maximumChunkSize) {
        return new Chunk(maximumChunkSize);
    }
}

