/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events.server;

import com.worklight.location.internal.events.server.EmptyRequestListener;
import com.worklight.location.internal.events.server.IWLRequestFactory;
import com.worklight.location.internal.events.storage.Chunk;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLRequestOptions;
import org.json.JSONArray;

public class EventServer {
    private static final WLRequestListener EMPTY_LISTENER = new EmptyRequestListener();
    private final IWLRequestFactory factory;

    public EventServer(IWLRequestFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        this.factory = factory;
    }

    public void send(Chunk data) {
        this.send(data, EMPTY_LISTENER);
    }

    public void send(Chunk data, WLRequestListener requestListener) {
        WLRequestOptions options = new WLRequestOptions();
        JSONArray array = new JSONArray();
        for (int i = 0; i < data.numberOfEvents(); ++i) {
            array.put((Object)data.get(i));
        }
        options.getParameters().put("events", array.toString());
        this.factory.createWLRequest(requestListener, options).makeRequest("events");
    }
}

