/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events.nativeImpl;

import com.worklight.location.internal.events.nativeImpl.FileChunkStorage;
import com.worklight.location.internal.events.nativeImpl.FileLockResources;
import com.worklight.location.internal.events.storage.ChunkStorage;
import com.worklight.location.internal.events.storage.ChunkStringFactory;
import com.worklight.location.internal.events.storage.IChunkStorage;
import com.worklight.location.internal.events.storage.IPersistentStorageManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class FilePersistentStorageManager
implements IPersistentStorageManager {
    private final Collection<FileLockResources> lockResources = new ArrayList<FileLockResources>();
    private final File workingDir;
    private final long maximumMemorySize;

    public FilePersistentStorageManager(File workingDir, long maximumMemorySize) {
        if (!workingDir.exists() || !workingDir.isDirectory()) {
            throw new IllegalArgumentException("workingDir is not an existing directory");
        }
        this.workingDir = workingDir;
        if (maximumMemorySize <= 0L) {
            throw new IllegalArgumentException("maximumMemorySize must be a positive integer, was " + maximumMemorySize);
        }
        this.maximumMemorySize = maximumMemorySize;
    }

    @Override
    public IChunkStorage createStorage() {
        File storageDir = new File(this.workingDir, UUID.randomUUID().toString());
        storageDir.mkdir();
        FileLockResources lockData = FilePersistentStorageManager.tryLockDirectory(storageDir);
        if (lockData == null) {
            throw new AssertionError((Object)"Could not lock the file");
        }
        this.lockResources.add(lockData);
        return new ChunkStorage(this.maximumMemorySize, new FileChunkStorage(storageDir, new ChunkStringFactory()));
    }

    private static FileLockResources tryLockDirectory(File dir) {
        try {
            File lockedFile = new File(dir, ".filelock");
            if (!lockedFile.exists()) {
                lockedFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(lockedFile);
            FileChannel channel = fos.getChannel();
            FileLockResources fileLockData = new FileLockResources(fos, channel, channel.lock());
            return fileLockData;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (OverlappingFileLockException e) {
            return null;
        }
    }

    @Override
    public void clearOldPersistentData() {
        for (File dir : this.workingDir.listFiles()) {
            FileLockResources tryLockResult = FilePersistentStorageManager.tryLockDirectory(dir);
            if (tryLockResult == null) continue;
            tryLockResult.close();
            FilePersistentStorageManager.deleteDirectory(dir);
        }
    }

    private static void deleteDirectory(File dir) {
        for (File f : dir.listFiles()) {
            if (f.delete()) continue;
            throw new RuntimeException("Could not delete file " + f.getAbsolutePath());
        }
        if (!dir.delete()) {
            throw new RuntimeException("Could not delete dir " + dir.getName());
        }
    }

    void clearAll() throws Exception {
        for (FileLockResources lockData : this.lockResources) {
            lockData.close();
        }
        this.lockResources.clear();
        System.gc();
        Thread.sleep(10L);
        for (File dir : this.workingDir.listFiles()) {
            FilePersistentStorageManager.deleteDirectory(dir);
        }
    }
}

