/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events.nativeImpl;

import com.worklight.location.internal.events.storage.Chunk;
import com.worklight.location.internal.events.storage.ChunkStringFactory;
import com.worklight.location.internal.events.storage.IChunkStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import org.json.JSONException;

public class FileChunkStorage
implements IChunkStorage {
    private static final String FILE_PREFIX = "ChunkFile";
    private static final String UTF8 = "UTF-8";
    private final File workingDir;
    private final ChunkStringFactory factory;
    private long startIndex = 0L;
    private long currentIndex = 0L;

    public FileChunkStorage(File workingDir, ChunkStringFactory factory) {
        if (!workingDir.exists() || !workingDir.isDirectory()) {
            throw new IllegalArgumentException("workingDir is not an existing directory");
        }
        this.workingDir = workingDir;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        this.factory = factory;
    }

    @Override
    public void store(Chunk c) {
        FileOutputStream fos = null;
        try {
            File file = this.getFileForIndex(this.currentIndex++);
            file.createNewFile();
            fos = new FileOutputStream(file);
            fos.write(this.factory.createString(c).getBytes(UTF8));
            fos.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    @Override
    public Chunk getFirst() {
        return this.loadChunk(this.startIndex);
    }

    private Chunk loadChunk(long fileIdx) throws AssertionError {
        if (this.isEmpty()) {
            return null;
        }
        Scanner scanner = null;
        try {
            File f = this.getFileForIndex(fileIdx);
            scanner = new Scanner(f, UTF8);
            scanner.useDelimiter("\\A");
            Chunk chunk = this.factory.createChunk(scanner.next());
            return chunk;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    @Override
    public void removeFirst() {
        if (this.isEmpty()) {
            return;
        }
        File f = this.getFileForIndex(this.startIndex);
        f.delete();
        ++this.startIndex;
    }

    @Override
    public void purgeAll() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getNumChunks() == 0L;
    }

    private File getFileForIndex(long i) {
        File f = new File(this.workingDir, FILE_PREFIX + i);
        return f;
    }

    @Override
    public void setMaxmiumMemorySize(long maximumMemorySize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Chunk getChunk(long idx) {
        try {
            return this.loadChunk(this.startIndex + idx);
        }
        catch (AssertionError e) {
            return null;
        }
    }

    @Override
    public long getNumChunks() {
        return this.currentIndex - this.startIndex;
    }

    @Override
    public long getNumChunksPersisted() {
        return this.getNumChunks();
    }

    public Chunk forTestOnly_loadChunk(int idx) {
        return this.getChunk((long)idx - this.startIndex);
    }
}

