/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events;

import com.worklight.location.internal.events.EventTransmitter;
import com.worklight.location.internal.events.PiggybackerFlush;
import com.worklight.wlclient.WLRequestPiggybacker;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import java.util.Timer;
import java.util.TimerTask;

final class EventTransmitterPiggybacker
implements WLRequestPiggybacker {
    private final long delay;
    private final EventTransmitter eventTransmitter;
    private Timer timer;

    public EventTransmitterPiggybacker(EventTransmitter et, long delay) {
        this.eventTransmitter = et;
        this.delay = delay;
    }

    @Override
    public void processOptions(String requestPath, WLRequestOptions options) {
    }

    @Override
    public synchronized void onSuccess(WLResponse response) {
        this.eventTransmitter.setClientConnected(true);
        if (this.eventTransmitter.isTransmitting()) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("Piggybacker timer");
        this.timer.schedule((TimerTask)new PiggybackerFlush(this), this.delay);
    }

    public EventTransmitter getEventTransmitter() {
        return this.eventTransmitter;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void onFailure(WLFailResponse response) {
        WLErrorCode wlErrorCode = response.getErrorCode();
        if (wlErrorCode != null) {
            switch (response.getErrorCode()) {
                case UNRESPONSIVE_HOST: 
                case REQUEST_TIMEOUT: 
                case REQUEST_SERVICE_NOT_FOUND: 
                case APP_VERSION_ACCESS_DENIAL: {
                    this.eventTransmitter.setClientConnected(false);
                    break;
                }
            }
        }
    }
}

