/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.events;

import com.worklight.common.Logger;
import com.worklight.location.api.WLEventTransmissionPolicy;
import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.PiggbackRegisterer;
import com.worklight.location.internal.events.ChunkTransmissionRequestListener;
import com.worklight.location.internal.events.EventFlusher;
import com.worklight.location.internal.events.PiggybackerFactory;
import com.worklight.location.internal.events.server.EventServer;
import com.worklight.location.internal.events.storage.Chunk;
import com.worklight.location.internal.events.storage.IChunkStorage;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class EventTransmitter {
    private Logger logger = Logger.getInstance("EventTransmitter");
    private static final long BYTES_IN_KILOBYTE = 1024L;
    private EventServer server;
    private final DeviceContextImpl dc;
    private final IChunkStorage storage;
    private Chunk openChunk;
    private WLEventTransmissionPolicy policy;
    private Timer timer;
    private int retriesLeft;
    private boolean isTransmitting = false;
    private long lastFlush = -1L;
    private boolean isClientConnected = false;
    private int purgeCounter = 0;
    private boolean inTestingEnv = false;
    private boolean eventsHaveBeenAdded = false;

    public EventTransmitter(EventServer server, DeviceContextImpl dc, IChunkStorage storage) {
        this(server, dc, new Chunk((long)WLEventTransmissionPolicy.getDefaultPolicy().getMaxChunkSize() * 1024L), storage, WLEventTransmissionPolicy.getDefaultPolicy(), new PiggbackRegisterer(), new PiggybackerFactory(), false);
    }

    EventTransmitter(EventServer server, DeviceContextImpl dc, Chunk openChunk, IChunkStorage storage, WLEventTransmissionPolicy policy, PiggbackRegisterer registerer, PiggybackerFactory factory, boolean inTestingEnv) {
        if (server == null) {
            throw new IllegalArgumentException("server is null");
        }
        this.server = server;
        if (dc == null) {
            throw new IllegalArgumentException("dc is null");
        }
        this.dc = dc;
        if (openChunk == null) {
            throw new IllegalArgumentException("openChunk is null");
        }
        this.openChunk = openChunk;
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
        this.policy = policy;
        this.retriesLeft = policy.getNumRetries();
        this.inTestingEnv = inTestingEnv;
        this.setEventTransmissionPolicy(policy);
        registerer.register(factory.create(this, 2000L));
    }

    private synchronized void addEventToChunk(JSONObject event, DeviceContextImpl currentDeviceContext) {
        try {
            if (!event.has("deviceContext")) {
                currentDeviceContext.addToEvent(event);
            }
            if (!this.openChunk.add(event)) {
                this.storage.store(this.openChunk);
                this.openChunk = this.openChunk.createNewChunk();
                this.openChunk.add(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public synchronized void transmitEvent(JSONObject event, boolean transmitImmidiately) {
        this.transmitEvents(Collections.singletonList(event), transmitImmidiately);
    }

    public synchronized void transmitEvents(List<JSONObject> objects, boolean transmitImmidiately) {
        DeviceContextImpl currDC = this.dc.clone();
        if (!objects.isEmpty()) {
            this.eventsHaveBeenAdded = true;
        }
        for (JSONObject o : objects) {
            this.addEventToChunk(o, currDC);
        }
        if (!this.isTransmitting) {
            if (transmitImmidiately) {
                this.flushEvents();
            } else if (this.timer == null) {
                this.resetTimer();
            }
        }
    }

    public synchronized void setEventTransmissionPolicy(WLEventTransmissionPolicy p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.policy = p.clone();
        long chunkSize = (long)p.getMaxChunkSize() * 1024L;
        if (p.isEventStorageEnabled()) {
            this.storage.setMaxmiumMemorySize(Math.max(chunkSize, (long)p.getMaxMemSize() * 1024L - chunkSize));
        } else {
            this.storage.setMaxmiumMemorySize(Long.MAX_VALUE);
        }
        if (this.openChunk.currentChunkSize() != 0L) {
            this.storage.store(this.openChunk);
        }
        this.openChunk = this.openChunk.createNewChunk(chunkSize);
        this.resetTimer();
    }

    private void clearTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void resetTimer() {
        this.clearTimer();
        if (this.hasEvents() && !this.isTransmitting) {
            long delay = this.policy.getInterval();
            if (this.lastFlush > 0L) {
                delay -= (System.currentTimeMillis() - this.lastFlush) % this.policy.getInterval();
            }
            this.scheduleTimer(delay);
        }
    }

    private void scheduleTimer(long delay) {
        this.timer = new Timer("Event Transmitter Timer");
        this.timer.schedule((TimerTask)new EventFlusher(this), delay);
    }

    private boolean hasEvents() {
        return this.eventsHaveBeenAdded && (this.openChunk.numberOfEvents() > 0 || !this.storage.isEmpty());
    }

    synchronized boolean isTransmitting() {
        return this.isTransmitting;
    }

    public synchronized void flushEventsFromAsync() {
        if (!this.isTransmitting && this.eventsHaveBeenAdded) {
            this.flushEvents();
        }
    }

    public synchronized void flushEvents() {
        this.debugLog("Flush called");
        if (this.isTransmitting) {
            return;
        }
        if (!this.isClientConnected) {
            return;
        }
        this.isTransmitting = true;
        this.clearTimer();
        this.lastFlush = System.currentTimeMillis();
        if (this.storage.isEmpty()) {
            if (this.openChunk.numberOfEvents() > 0) {
                this.storage.store(this.openChunk);
                this.openChunk = this.openChunk.createNewChunk();
            } else {
                this.isTransmitting = false;
                return;
            }
        }
        int currPurgeCounter = this.purgeCounter;
        this.debugLog("Transmitting...:");
        this.server.send(this.storage.getFirst(), new ChunkTransmissionRequestListener(this, currPurgeCounter));
    }

    public synchronized void purgeEvents() {
        this.storage.purgeAll();
        this.openChunk = this.openChunk.createNewChunk();
        ++this.purgeCounter;
        this.clearTimer();
    }

    public synchronized void setClientConnected(boolean connected) {
        this.isClientConnected = connected;
    }

    synchronized void txSuccess(int purgeCounterAtTx) {
        this.debugLog("Succesfully transmitted a chunk");
        if (purgeCounterAtTx == this.purgeCounter) {
            this.storage.removeFirst();
        }
        this.retriesLeft = this.policy.getNumRetries();
        this.isTransmitting = false;
        if (this.hasEvents()) {
            this.flushEvents();
        }
    }

    synchronized void txFailure() {
        this.isTransmitting = false;
        if (this.retriesLeft == 0) {
            this.debugLog("Failed to transmit " + this.policy.getNumRetries() + " times, giving up this transmission, will try again according to the given interval");
            this.retriesLeft = this.policy.getNumRetries();
            this.resetTimer();
        } else {
            this.debugLog("Failed to transmit chunk, retrying");
            --this.retriesLeft;
            this.scheduleTimer(this.policy.getRetryInterval());
        }
    }

    private void debugLog(String message) {
        if (!this.inTestingEnv) {
            this.logger.debug(Thread.currentThread().getName() + " - " + message);
        }
    }

    public synchronized void forTestOnly_setEventServer(EventServer server) {
        this.server = server;
    }

    public synchronized IChunkStorage forTestOnly_getChunkStorage() {
        return this.storage;
    }
}

