/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.deviceContextPiggybacker;

import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.deviceContextPiggybacker.DeviceContextPiggybacker;
import com.worklight.location.internal.deviceContextPiggybacker.SensorEncoder;

final class LastModifiedSensorEncoder
implements SensorEncoder<Long> {
    private final DeviceContextPiggybacker deviceContextPiggybacker;
    private final DeviceContextImpl deviceContext;

    LastModifiedSensorEncoder(DeviceContextPiggybacker deviceContextPiggybacker, DeviceContextImpl deviceContext) {
        this.deviceContextPiggybacker = deviceContextPiggybacker;
        this.deviceContext = deviceContext;
    }

    @Override
    public void encode(Long lastModified) {
        long maxTimestamp = -1L;
        if (this.deviceContext.getGeoPosition() != null && this.deviceContext.getGeoPosition().getTimestamp() != null) {
            maxTimestamp = this.deviceContext.getGeoPosition().getTimestamp();
        }
        if (this.deviceContext.getWifiLocation() != null && this.deviceContext.getWifiLocation().getTimestamp() != null) {
            maxTimestamp = Math.max(maxTimestamp, this.deviceContext.getWifiLocation().getTimestamp());
        }
        if (lastModified == maxTimestamp) {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(1L, 1));
        } else {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(0L, 1));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeNonNegativeNumber(lastModified));
        }
    }
}

