/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.deviceContextPiggybacker;

import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.internal.deviceContextPiggybacker.DeviceContextPiggybacker;
import com.worklight.location.internal.deviceContextPiggybacker.SensorEncoder;

final class GeoPositionSensorEncoder
implements SensorEncoder<WLGeoPosition> {
    private final DeviceContextPiggybacker deviceContextPiggybacker;

    GeoPositionSensorEncoder(DeviceContextPiggybacker deviceContextPiggybacker) {
        this.deviceContextPiggybacker = deviceContextPiggybacker;
    }

    @Override
    public void encode(WLGeoPosition geo) {
        boolean hasAltitudeAccuracy;
        boolean hasCoords;
        WLCoordinate coords = geo.getCoordinate();
        boolean hasTimestamp = geo.getTimestamp() != null;
        boolean hasLongitude = hasCoords = coords != null;
        boolean hasLatitude = hasCoords;
        boolean hasAccuracy = hasCoords;
        boolean hasSpeed = hasCoords && coords.getSpeed() != null;
        boolean hasHeading = hasCoords && coords.getHeading() != null;
        boolean hasAltitude = hasCoords && coords.getAltitude() != null;
        boolean bl = hasAltitudeAccuracy = hasCoords && coords.getAltitudeAccuracy() != null;
        if (hasTimestamp && hasLongitude && hasLatitude && hasAccuracy && hasSpeed && hasHeading && hasAltitude && hasAltitudeAccuracy) {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(1L, 1));
        } else {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(0L, 1));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasTimestamp));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasLongitude));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasLatitude));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasAccuracy));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasSpeed));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasHeading));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasAltitude));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(hasAltitudeAccuracy));
        }
        if (hasTimestamp) {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeNonNegativeNumber(geo.getTimestamp()));
        }
        String separator = "";
        if (hasLongitude) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getLongitude(), separator);
        }
        if (hasLongitude) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getLatitude(), separator);
        }
        if (hasAccuracy) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getAccuracy(), separator);
        }
        if (hasSpeed) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getSpeed(), separator);
        }
        if (hasHeading) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getHeading(), separator);
        }
        if (hasAltitude) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getAltitude(), separator);
        }
        if (hasAltitudeAccuracy) {
            separator = this.deviceContextPiggybacker.encodeCoordsValue(coords.getAltitudeAccuracy(), separator);
        }
        this.deviceContextPiggybacker.textData.append(separator);
    }
}

