/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.deviceContextPiggybacker;

import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.deviceContextPiggybacker.GeoPositionSensorEncoder;
import com.worklight.location.internal.deviceContextPiggybacker.LastModifiedSensorEncoder;
import com.worklight.location.internal.deviceContextPiggybacker.SensorEncoder;
import com.worklight.location.internal.deviceContextPiggybacker.TimezoneOffsetSensorEncoder;
import com.worklight.location.internal.deviceContextPiggybacker.WifiLocationSensorEncoder;
import com.worklight.wlclient.WLRequestPiggybacker;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class DeviceContextPiggybacker
implements WLRequestPiggybacker {
    private static final String SECURE_RANDOME_ALGORITHM = "SHA1PRNG";
    private final DeviceContextImpl dc;
    private final int sessionRandom;
    private final long sessionTimestamp;
    private long outstandingValue = 0L;
    private int numOutstandingBits = 0;
    private StringBuilder binaryData = new StringBuilder();
    StringBuilder textData = new StringBuilder();
    StringBuilder sensorInfo = new StringBuilder();
    private StringBuilder temp = new StringBuilder();

    public DeviceContextPiggybacker(DeviceContextImpl dc) {
        this.dc = dc;
        try {
            this.sessionRandom = (int)Math.floor(1.6777216E7 * SecureRandom.getInstance(SECURE_RANDOME_ALGORITHM).nextDouble());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e.getMessage());
        }
        this.sessionTimestamp = System.currentTimeMillis();
    }

    @Override
    public void processOptions(String requestPath, WLRequestOptions options) {
        if (!(requestPath.endsWith("events") || requestPath.endsWith("query") || requestPath.endsWith("invoke"))) {
            return;
        }
        options.getParameters().put("__wl_deviceCtx", this.getMessage(this.dc.clone()));
    }

    @Override
    public void onSuccess(WLResponse response) {
    }

    @Override
    public void onFailure(WLFailResponse response) {
    }

    private synchronized String getMessage(DeviceContextImpl deviceContext) {
        this.outstandingValue = 0L;
        this.numOutstandingBits = 0;
        this.binaryData.setLength(0);
        this.textData.setLength(0);
        this.sensorInfo.setLength(0);
        this.temp.setLength(0);
        this.binaryData.append(this.encodeNonNegativeNumber(0L));
        this.binaryData.append(this.writeNumber(this.sessionRandom, 24));
        this.binaryData.append(this.encodeNonNegativeNumber(this.sessionTimestamp));
        this.binaryData.append(this.encodeNonNegativeNumber(deviceContext.getVersion()));
        this.binaryData.append(this.finishEncode());
        if (deviceContext.getGeoPosition() == null && deviceContext.getWifiLocation() == null) {
            this.binaryData.append(this.encodeNonNegativeNumber(0L));
            return this.binaryData.toString();
        }
        this.encodeSensor(deviceContext.getGeoPosition(), new GeoPositionSensorEncoder(this));
        this.encodeSensor(deviceContext.getWifiLocation(), new WifiLocationSensorEncoder(this));
        this.encodeSensor(deviceContext.getLastModified(), new LastModifiedSensorEncoder(this, deviceContext));
        this.encodeSensor(deviceContext.getTimezoneOffset(), new TimezoneOffsetSensorEncoder(this));
        this.sensorInfo.append(this.finishEncode());
        this.binaryData.append(this.encodeNonNegativeNumber(this.sensorInfo.length())).append((CharSequence)this.sensorInfo).append((CharSequence)this.textData);
        String result = this.binaryData.toString();
        this.binaryData.setLength(0);
        this.textData.setLength(0);
        this.sensorInfo.setLength(0);
        return result;
    }

    <T> void encodeSensor(T sensor, SensorEncoder<T> encoder) {
        if (sensor == null) {
            this.sensorInfo.append(this.encodeBoolean(false));
        } else {
            this.sensorInfo.append(this.encodeBoolean(true));
            encoder.encode(sensor);
        }
    }

    String encodeCoordsValue(Object value, String separator) {
        this.textData.append(separator);
        if (value == null) {
            this.textData.append('_');
            return "";
        }
        this.textData.append(value);
        return "~";
    }

    private char base64AEncode(long num) {
        if ((num &= 0x3FL) < 26L) {
            return (char)(65L + num);
        }
        if (num < 52L) {
            return (char)(97L + num - 26L);
        }
        if (num < 62L) {
            return (char)(48L + num - 52L);
        }
        if (num == 62L) {
            return '-';
        }
        if (num == 63L) {
            return '_';
        }
        throw new IllegalStateException("Internal error in base64AEncode");
    }

    private String finishEncode() {
        if (this.numOutstandingBits == 0) {
            return "";
        }
        String result = this.writeNumber(0L, 6 - this.numOutstandingBits);
        this.numOutstandingBits = 0;
        this.outstandingValue = 0L;
        return result;
    }

    private String clearTemp(int length) {
        String result = this.temp.substring(length);
        this.temp.setLength(length);
        return result;
    }

    String writeNumber(long code, int numBits) {
        if (numBits == 0) {
            return "";
        }
        int numNewBits = this.numOutstandingBits + numBits;
        if (numNewBits < 6) {
            this.outstandingValue <<= numBits;
            this.outstandingValue += code & (long)((1 << numBits) - 1);
            this.numOutstandingBits = numNewBits;
            return "";
        }
        int startingLength = this.temp.length();
        while (numNewBits >= 6) {
            int charNewBits = 6 - this.numOutstandingBits;
            this.outstandingValue <<= charNewBits;
            this.outstandingValue += code >> numBits - charNewBits & (long)((1 << charNewBits) - 1);
            this.temp.append(this.base64AEncode(this.outstandingValue));
            this.outstandingValue = 0L;
            this.numOutstandingBits = 0;
            numBits -= charNewBits;
            numNewBits -= 6;
        }
        this.outstandingValue = code & (long)((1 << numNewBits) - 1);
        this.numOutstandingBits = numNewBits;
        return this.clearTemp(startingLength);
    }

    String encodeWholeNumber(long num) {
        return this.encodeBoolean(num < 0L) + this.encodeNonNegativeNumber(Math.abs(num));
    }

    String encodeNonNegativeNumber(long num) {
        int startingLength = this.temp.length();
        boolean moreBits = true;
        while (moreBits) {
            long out = num & 0x1FL;
            if ((num >>= 5) > 0L) {
                out |= 0x20L;
            } else {
                moreBits = false;
            }
            this.temp.append(this.writeNumber(out, 6));
        }
        return this.clearTemp(startingLength);
    }

    String encodeBoolean(boolean value) {
        return this.writeNumber(value ? 1 : 0, 1);
    }

    int getNumBitsToEncode(int num) {
        return Integer.numberOfTrailingZeros(Integer.highestOneBit(num + 1));
    }
}

