/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.deviceContextPiggybacker;

import com.worklight.location.api.wifi.WLWifiAccessPoint;
import com.worklight.location.api.wifi.WLWifiLocation;
import com.worklight.location.internal.deviceContextPiggybacker.DeviceContextPiggybacker;
import com.worklight.location.internal.deviceContextPiggybacker.SensorEncoder;
import com.worklight.location.internal.deviceContextPiggybacker.WifiMacSensorEncoder;
import java.util.ArrayList;
import java.util.List;

final class AccessPointsSensorEncoder
implements SensorEncoder<List<WLWifiAccessPoint>> {
    private final DeviceContextPiggybacker deviceContextPiggybacker;
    private final WLWifiLocation wifi;

    AccessPointsSensorEncoder(DeviceContextPiggybacker deviceContextPiggybacker, WLWifiLocation wifi) {
        this.deviceContextPiggybacker = deviceContextPiggybacker;
        this.wifi = wifi;
    }

    @Override
    public void encode(List<WLWifiAccessPoint> accessPoints) {
        this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeNonNegativeNumber(accessPoints.size()));
        ArrayList<String> ssids = new ArrayList<String>();
        int connectedAccessPointIdx = -1;
        int apIdx = -1;
        for (WLWifiAccessPoint ap : accessPoints) {
            ++apIdx;
            int idxFound = -1;
            for (int i = 0; i < ssids.size(); ++i) {
                if (!((String)ssids.get(i)).equals(ap.getSSID())) continue;
                idxFound = i;
                break;
            }
            if (apIdx > 0) {
                this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(idxFound >= 0));
            }
            if (idxFound >= 0) {
                this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(idxFound, this.deviceContextPiggybacker.getNumBitsToEncode(ssids.size())));
            } else {
                this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeNonNegativeNumber(ap.getSSID().length() - 1));
                this.deviceContextPiggybacker.textData.append(ap.getSSID());
                ssids.add(ap.getSSID());
            }
            this.deviceContextPiggybacker.encodeSensor(ap.getMAC(), new WifiMacSensorEncoder(this.deviceContextPiggybacker));
            if (!ap.equals(this.wifi.getConnectedAccessPoint())) continue;
            connectedAccessPointIdx = apIdx;
        }
        if (connectedAccessPointIdx < 0) {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(false));
        } else {
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.encodeBoolean(true));
            this.deviceContextPiggybacker.sensorInfo.append(this.deviceContextPiggybacker.writeNumber(connectedAccessPointIdx, this.deviceContextPiggybacker.getNumBitsToEncode(accessPoints.size())));
        }
    }
}

