/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal;

import com.worklight.common.Logger;
import com.worklight.location.api.WLLocationServicesConfiguration;
import com.worklight.location.api.WLTriggerCallback;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.api.geo.triggers.WLGeoTrigger;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.api.wifi.triggers.WLWifiTrigger;
import com.worklight.location.internal.AbstractTrigger;
import com.worklight.location.internal.AbstractTriggerEvaluator;
import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.ICallbackExecutor;
import com.worklight.location.internal.TriggerEvaluatorBuilder;
import com.worklight.location.internal.events.EventTransmitter;
import com.worklight.location.internal.geo.triggerEvaluators.GeoTriggerEvaluator;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiInternalLocation;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiTriggerEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class RuntimeTriggerContainer {
    private static Logger logger = Logger.getInstance("RuntimeTriggerContainer");
    private final DeviceContextImpl deviceContext;
    private final EventTransmitter eventTransmitter;
    private final TriggerEvaluatorBuilder builder;
    private Map<String, GeoTriggerEvaluator> geoTriggerEvaluators = new HashMap<String, GeoTriggerEvaluator>();
    private Map<String, WifiTriggerEvaluator> wifiTriggerEvaluators = new HashMap<String, WifiTriggerEvaluator>();
    private final ICallbackExecutor executor;

    public RuntimeTriggerContainer(DeviceContextImpl deviceContext, EventTransmitter eventTransmitter, ICallbackExecutor executor) {
        this(deviceContext, eventTransmitter, new TriggerEvaluatorBuilder(), executor);
    }

    RuntimeTriggerContainer(DeviceContextImpl deviceContext, EventTransmitter eventTransmitter, TriggerEvaluatorBuilder builder, ICallbackExecutor executor) {
        if (deviceContext == null) {
            throw new IllegalArgumentException("deviceContext is null");
        }
        this.deviceContext = deviceContext;
        if (eventTransmitter == null) {
            throw new IllegalArgumentException("eventTransmitter is null");
        }
        this.eventTransmitter = eventTransmitter;
        if (builder == null) {
            throw new IllegalArgumentException("builder is null");
        }
        this.builder = builder;
        if (executor == null) {
            throw new IllegalArgumentException("executor is null");
        }
        this.executor = executor;
    }

    private Map<String, GeoTriggerEvaluator> buildGeoMap(Map<String, WLGeoTrigger> map) {
        HashMap<String, GeoTriggerEvaluator> $ = new HashMap<String, GeoTriggerEvaluator>();
        if (map == null) {
            return $;
        }
        for (Map.Entry<String, WLGeoTrigger> entry : map.entrySet()) {
            $.put(entry.getKey(), this.builder.buildGeoTrigger(entry.getValue()));
        }
        return $;
    }

    private Map<String, WifiTriggerEvaluator> buildWifiMap(Map<String, WLWifiTrigger> map) {
        HashMap<String, WifiTriggerEvaluator> $ = new HashMap<String, WifiTriggerEvaluator>();
        if (map == null) {
            return $;
        }
        for (Map.Entry<String, WLWifiTrigger> entry : map.entrySet()) {
            $.put(entry.getKey(), this.builder.buildWifiTrigger(entry.getValue()));
        }
        return $;
    }

    public void updateConfiguration(WLLocationServicesConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        RuntimeTriggerContainer.validateWifiPolicy(config.getPolicy().getWifiPolicy(), this.getWifiTriggers(config));
        Map<String, GeoTriggerEvaluator> tempGeoMap = this.buildGeoMap(this.getGeoTriggers(config));
        Map<String, WifiTriggerEvaluator> tempWifiMap = this.buildWifiMap(this.getWifiTriggers(config));
        for (Map.Entry<String, GeoTriggerEvaluator> entry : this.geoTriggerEvaluators.entrySet()) {
            if (tempGeoMap.containsKey(entry.getKey())) {
                tempGeoMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            entry.getValue().preDestroy();
        }
        for (Map.Entry<String, AbstractTriggerEvaluator> entry : this.wifiTriggerEvaluators.entrySet()) {
            if (tempWifiMap.containsKey(entry.getKey())) {
                tempWifiMap.put(entry.getKey(), (WifiTriggerEvaluator)entry.getValue());
                continue;
            }
            ((WifiTriggerEvaluator)entry.getValue()).preDestroy();
        }
        this.geoTriggerEvaluators = tempGeoMap;
        this.wifiTriggerEvaluators = tempWifiMap;
        for (GeoTriggerEvaluator geoTriggerEvaluator : this.geoTriggerEvaluators.values()) {
            geoTriggerEvaluator.notifyOfConfigurationUpdate(config);
        }
        for (WifiTriggerEvaluator wifiTriggerEvaluator : this.wifiTriggerEvaluators.values()) {
            wifiTriggerEvaluator.notifyOfConfigurationUpdate(config);
        }
    }

    private Map<String, WLGeoTrigger> getGeoTriggers(WLLocationServicesConfiguration config) {
        if (config.getTriggers() == null) {
            return null;
        }
        return config.getTriggers().getGeoTriggers();
    }

    private Map<String, WLWifiTrigger> getWifiTriggers(WLLocationServicesConfiguration config) {
        if (config.getTriggers() == null) {
            return null;
        }
        return config.getTriggers().getWifiTriggers();
    }

    private static void validateWifiPolicy(WLWifiAcquisitionPolicy policy, Map<String, WLWifiTrigger> wifiTriggerDefintions) {
        if (wifiTriggerDefintions == null) {
            return;
        }
        for (Map.Entry<String, WLWifiTrigger> triggerDef : wifiTriggerDefintions.entrySet()) {
            if (triggerDef.getValue().validate(policy)) continue;
            logger.error("The WIFI trigger" + triggerDef + "will have no affect, since its network do not appear in WIFI acquisition policy");
        }
    }

    private List<AbstractTriggerEvaluator> getWifiTriggersEvalutedToTrue(WifiInternalLocation position) {
        ArrayList<AbstractTriggerEvaluator> $ = new ArrayList<AbstractTriggerEvaluator>();
        for (WifiTriggerEvaluator trigger : this.wifiTriggerEvaluators.values()) {
            if (!trigger.evaluate(position)) continue;
            $.add(trigger);
        }
        return $;
    }

    private List<AbstractTriggerEvaluator> getGeoTriggersEvalutedToTrue(WLGeoPosition position) {
        ArrayList<AbstractTriggerEvaluator> $ = new ArrayList<AbstractTriggerEvaluator>();
        for (GeoTriggerEvaluator trigger : this.geoTriggerEvaluators.values()) {
            if (!trigger.evaluate(position)) continue;
            $.add(trigger);
        }
        return $;
    }

    private void handleTriggersEvalutedToTrue(List<? extends AbstractTriggerEvaluator> triggers) {
        ArrayList<JSONObject> events = new ArrayList<JSONObject>();
        boolean transmitImmedietly = false;
        ArrayList<WLTriggerCallback> callbacks = new ArrayList<WLTriggerCallback>();
        for (AbstractTriggerEvaluator abstractTriggerEvaluator : triggers) {
            AbstractTrigger triggerDefinition = abstractTriggerEvaluator.getTriggerDefinition();
            if (triggerDefinition.getEvent() != null) {
                events.add(triggerDefinition.getEvent());
                transmitImmedietly |= triggerDefinition.isTransmitImmediately();
            }
            if (triggerDefinition.getCallback() == null) continue;
            callbacks.add(triggerDefinition.getCallback());
        }
        if (!events.isEmpty()) {
            this.eventTransmitter.transmitEvents(events, transmitImmedietly);
        }
        for (WLTriggerCallback wLTriggerCallback : callbacks) {
            this.executor.executeTriggerCallback(wLTriggerCallback, this.deviceContext.clone());
        }
    }

    public void geoLocationAcquired(WLGeoPosition position) {
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        this.deviceContext.setGeoPosition(position);
        this.handleTriggersEvalutedToTrue(this.getGeoTriggersEvalutedToTrue(position));
    }

    public void wifiLocationAcquired(WifiInternalLocation position) {
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        this.deviceContext.setWifiPosition(position.getPublicVersion());
        this.handleTriggersEvalutedToTrue(this.getWifiTriggersEvalutedToTrue(position));
    }

    public void clear() {
        for (GeoTriggerEvaluator geoTriggerEvaluator : this.geoTriggerEvaluators.values()) {
            geoTriggerEvaluator.preDestroy();
        }
        for (WifiTriggerEvaluator wifiTriggerEvaluator : this.wifiTriggerEvaluators.values()) {
            wifiTriggerEvaluator.preDestroy();
        }
        this.geoTriggerEvaluators.clear();
        this.wifiTriggerEvaluators.clear();
    }
}

