/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.api.geo.WLPolygon;
import java.util.ArrayList;
import java.util.HashMap;

public class InternalGeoUtils {
    private static double EARTH_RADIUS = 6371000.0;

    public static WLCoordinate nearestPointOnLineSegment(WLCoordinate point, WLCoordinate p1, WLCoordinate p2) {
        WLCoordinate point4;
        double y4;
        double x4;
        if (p1.equals(p2)) {
            return p1;
        }
        double nearestLat = p1.getLatitude();
        double nearestLon = p1.getLongitude();
        double pLat = point.getLatitude();
        double pLon = point.getLongitude();
        double p1Lat = p1.getLatitude();
        double p1Lon = p1.getLongitude();
        double p2Lat = p2.getLatitude();
        double p2Lon = p2.getLongitude();
        double x1 = 0.0;
        double y1 = WLGeoUtils.getDistanceBetweenCoordinates(point, p1);
        double x2 = 1.0;
        double y2 = WLGeoUtils.getDistanceBetweenCoordinates(point, p2);
        WLCoordinate point3 = new WLCoordinate((p1Lat + p2Lat) / 2.0, (p1Lon + p2Lon) / 2.0, 0.0);
        double x3 = 0.5;
        double y3 = WLGeoUtils.getDistanceBetweenCoordinates(point, point3);
        boolean closestEndPointIs1 = y1 < y2;
        for (int i = 0; i < 30; ++i) {
            double x42;
            double temp;
            if (y2 < y1) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
            if (y3 < y2) {
                temp = x2;
                x2 = x3;
                x3 = temp;
                temp = y2;
                y2 = y3;
                y3 = temp;
                if (y2 < y1) {
                    double temp1 = x1;
                    x1 = x2;
                    x2 = temp1;
                    temp1 = y1;
                    y1 = y2;
                    y2 = temp1;
                }
            }
            nearestLon = p1Lon + x1 * (p2Lon - p1Lon);
            nearestLat = p1Lat + x1 * (p2Lat - p1Lat);
            if (x1 == x2 || x1 == x3 || x2 == x3) break;
            double minX = InternalGeoUtils.min(new double[]{x1, x2, x3});
            double[] dArray = new double[]{x1, x2, x3};
            double maxX = InternalGeoUtils.max(dArray);
            if (maxX - minX < 0.001) {
                double minY = InternalGeoUtils.min(new double[]{y1, y2, y3});
                double maxY = InternalGeoUtils.max(new double[]{y1, y2, y3});
                if (maxY - minY < 0.5) break;
            }
            double betaConst = (y2 - y1) / (x2 - x1);
            double alpha = (y3 - y2 - betaConst * (x3 - x2)) / ((x3 - x2) * (x3 - x1));
            double beta = betaConst - alpha * (x2 + x1);
            if (alpha != 0.0) {
                x42 = -beta / (2.0 * alpha);
            } else {
                double midX = x1;
                if (midX == minX || midX == maxX) {
                    midX = x2;
                }
                if (midX == minX || midX == maxX) {
                    midX = x3;
                }
                x42 = maxX - midX > midX - minX ? Math.min(1.0, midX + 0.382 * (maxX - midX)) : Math.max(0.0, midX - 0.382 * (midX - minX));
            }
            WLCoordinate point42 = new WLCoordinate(p1Lat + x42 * (p2Lat - p1Lat), p1Lon + x42 * (p2Lon - p1Lon), 0.0);
            double y42 = WLGeoUtils.getDistanceBetweenCoordinates(point, point42);
            x3 = x42;
            y3 = y42;
        }
        if (y3 < y1) {
            x1 = x3;
            y1 = y3;
            nearestLon = p1Lon + x1 * (p2Lon - p1Lon);
            nearestLat = p1Lat + x1 * (p2Lat - p1Lat);
        }
        if ((x4 = ((pLon - p1Lon) * (p2Lon - p1Lon) + (pLat - p1Lat) * (p2Lat - p1Lat)) / ((p2Lon - p1Lon) * (p2Lon - p1Lon) + (p2Lat - p1Lat) * (p2Lat - p1Lat))) >= 0.0 && x4 <= 1.0 && (y4 = WLGeoUtils.getDistanceBetweenCoordinates(point, point4 = new WLCoordinate(p1Lat + x4 * (p2Lat - p1Lat), p1Lon + x4 * (p2Lon - p1Lon), 0.0))) < y1) {
            nearestLon = p1Lon + x4 * (p2Lon - p1Lon);
            nearestLat = p1Lat + x4 * (p2Lat - p1Lat);
        }
        if (InternalGeoUtils.sign(nearestLat - p1Lat) == InternalGeoUtils.sign(nearestLat - p2Lat) && InternalGeoUtils.sign(nearestLon - p1Lon) == InternalGeoUtils.sign(nearestLon - p2Lon)) {
            if (closestEndPointIs1) {
                nearestLon = p1Lon;
                nearestLat = p1Lat;
            } else {
                nearestLon = p2Lon;
                nearestLat = p2Lat;
            }
        }
        return new WLCoordinate(nearestLat, nearestLon, 0.0);
    }

    public static boolean isDistanceWithinConfidenceLevel(double distanceToBoundary, WLConfidenceLevel cl, double accuracy) {
        switch (cl) {
            case LOW: {
                return true;
            }
            case MEDIUM: {
                return distanceToBoundary > 0.5 * accuracy;
            }
            case HIGH: {
                return distanceToBoundary > 2.05 * accuracy;
            }
        }
        throw new AssertionError((Object)("Unknown WLConfidenceLevel value " + (Object)((Object)cl)));
    }

    public static boolean isInsidePolygonBoundary(WLCoordinate c, WLPolygon p) {
        WLPolygon oldPolygon = p;
        WLPolygon polygon = InternalGeoUtils.transformPolygon(p);
        WLCoordinate coordinate = c;
        if (!oldPolygon.equals(polygon)) {
            coordinate = InternalGeoUtils.transformCoordinate(c);
        }
        double pLon = coordinate.getLongitude();
        double pLat = coordinate.getLatitude();
        HashMap<Integer, Integer> slopes = new HashMap<Integer, Integer>();
        double slopeAngleInterval = 180.0 / (double)(polygon.length + 1);
        for (int i = 0; i < polygon.length; ++i) {
            double cLon = polygon.get(i).getLongitude();
            double cLat = polygon.get(i).getLatitude();
            if (cLon - pLon == 0.0) {
                slopes.put(0, 1);
                continue;
            }
            double angle = 90.0 + Math.atan((cLat - pLat) / (cLon - pLon));
            int slopeId = (int)Math.floor(angle / slopeAngleInterval);
            slopes.put(slopeId, 1);
        }
        double slope = 1.0;
        for (int i = 0; i <= polygon.length; ++i) {
            if (!slopes.containsKey(i) || (Integer)slopes.get(i) == 1) continue;
            slope = Math.tan(((double)i + 0.5) * slopeAngleInterval - 90.0);
            break;
        }
        int numCrossing = 0;
        double intercept = pLat - slope * pLon;
        for (int i = 0; i < polygon.length; ++i) {
            int s2;
            int nextI = (i + 1) % polygon.length;
            WLCoordinate pt1 = polygon.get(i);
            WLCoordinate pt2 = polygon.get(nextI);
            if (pt1.getLongitude() > pt2.getLongitude()) {
                pt1 = polygon.get(nextI);
                pt2 = polygon.get(i);
            }
            if (pLon > pt2.getLongitude()) continue;
            double lat1 = slope * pt1.getLongitude() + intercept;
            double lat2 = slope * pt2.getLongitude() + intercept;
            int s1 = InternalGeoUtils.sign(pt1.getLatitude() - lat1);
            if (s1 == (s2 = InternalGeoUtils.sign(pt2.getLatitude() - lat2)) && s2 == 0 && pLon >= pt1.getLongitude()) {
                return true;
            }
            if (s1 == s2 || s1 + s2 > 0) continue;
            if (pLon <= pt1.getLongitude() || s2 == 0) {
                ++numCrossing;
                continue;
            }
            double dlon = pt2.getLongitude() - pt1.getLongitude();
            if (dlon == 0.0) {
                ++numCrossing;
                continue;
            }
            double s3 = InternalGeoUtils.sign(dlon * (pLat - pt1.getLatitude()) - (pt2.getLatitude() - pt1.getLatitude()) * (pLon - pt1.getLongitude())) * InternalGeoUtils.sign(dlon);
            if (s3 != (double)s2) continue;
            ++numCrossing;
        }
        return numCrossing % 2 == 1;
    }

    public static double max(double[] args) {
        double min = Double.MIN_VALUE;
        for (double d : args) {
            if (!(min < d)) continue;
            min = d;
        }
        return min;
    }

    public static double min(double[] args) {
        double min = Double.MAX_VALUE;
        for (double d : args) {
            if (!(min > d)) continue;
            min = d;
        }
        return min;
    }

    public static double radians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double radiansToMeters(double radians) {
        return radians * EARTH_RADIUS;
    }

    public static int sign(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static WLCoordinate transformCoordinate(WLCoordinate coordinate) {
        return new WLCoordinate(coordinate.getLatitude(), InternalGeoUtils.transformLongitude(coordinate.getLongitude()), 0.0);
    }

    public static double transformLongitude(double lon) {
        return lon > 0.0 ? lon - 180.0 : lon + 180.0;
    }

    public static WLPolygon transformPolygon(WLPolygon p) {
        double minLon;
        int i = 0;
        double[] longsArr = new double[p.length];
        for (i = 0; i < longsArr.length; ++i) {
            longsArr[i] = p.get(i).getLongitude();
        }
        double maxLon = InternalGeoUtils.max(longsArr);
        if (maxLon - (minLon = InternalGeoUtils.min(longsArr)) < 180.0) {
            return p;
        }
        ArrayList<WLCoordinate> list = new ArrayList<WLCoordinate>();
        for (i = 0; i < p.length; ++i) {
            list.add(new WLCoordinate(p.get(i).getLatitude(), InternalGeoUtils.transformLongitude(p.get(i).getLongitude()), 0.0));
        }
        return new WLPolygon(list);
    }

    public static double distanceFromLineSegment(WLCoordinate point, WLCoordinate p1, WLCoordinate p2) {
        WLCoordinate nearestCoord = InternalGeoUtils.nearestPointOnLineSegment(point, p1, p2);
        return WLGeoUtils.getDistanceBetweenCoordinates(point, nearestCoord);
    }
}

