/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal;

import com.worklight.location.api.WLAcquisitionFailureCallbacksConfiguration;
import com.worklight.location.api.WLAcquisitionPolicy;
import com.worklight.location.api.WLDevice;
import com.worklight.location.api.WLDeviceContext;
import com.worklight.location.api.WLLocationServicesConfiguration;
import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoCallback;
import com.worklight.location.api.geo.WLGeoFailureCallback;
import com.worklight.location.api.wifi.WLWifiAcquisitionCallback;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.api.wifi.WLWifiConnectedCallback;
import com.worklight.location.api.wifi.WLWifiFailureCallback;
import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.ICallbackExecutor;
import com.worklight.location.internal.PiggbackRegisterer;
import com.worklight.location.internal.RuntimeTriggerContainer;
import com.worklight.location.internal.deviceContextPiggybacker.DeviceContextPiggybacker;
import com.worklight.location.internal.events.EventTransmitter;
import com.worklight.location.internal.events.server.EventServer;
import com.worklight.location.internal.events.server.IWLRequestFactory;
import com.worklight.location.internal.events.storage.IPersistentStorageManager;
import com.worklight.location.internal.geo.EmptyGeoPosition;
import com.worklight.location.internal.geo.GeoAcquisitor;
import com.worklight.location.internal.geo.GeoErrorLinker;
import com.worklight.location.internal.geo.RTCGeoAcquireLinker;
import com.worklight.location.internal.geo.RTCGeoLinker;
import com.worklight.location.internal.wifi.EmptyWifiPosition;
import com.worklight.location.internal.wifi.RTCWifiLinker;
import com.worklight.location.internal.wifi.WifiAcquisitionCallbackConverter;
import com.worklight.location.internal.wifi.WifiAcquisitor;
import com.worklight.location.internal.wifi.WifiConnectedCallbackConverter;
import com.worklight.location.internal.wifi.WifiErrorLinker;
import com.worklight.wlclient.WLRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DeviceImpl
implements WLDevice {
    private static final String NEW_CONFIGURATION = "newConfiguration";
    private static final String WIFI_POLICY = "wifiPolicy";
    private static final String GEO_POLICY = "geoPolicy";
    private static final String ON_FAILURE = "onFailure";
    private static final String ON_SUCCESS = "onSuccess";
    private WLLocationServicesConfiguration configuration;
    protected final DeviceContextImpl deviceContext = new DeviceContextImpl();
    private final WifiAcquisitor wifiAcq;
    final RuntimeTriggerContainer rtc;
    final GeoAcquisitor geoAcq;
    private final EventTransmitter eventTransmitter;
    private ICallbackExecutor executor;

    public DeviceImpl(WifiAcquisitor wifiAcquisitor, GeoAcquisitor geoAcquisitor, IPersistentStorageManager storeManager, IWLRequestFactory requestFactory, ICallbackExecutor executor) {
        this.executor = executor;
        if (wifiAcquisitor == null) {
            throw new IllegalArgumentException("wifiAcquisitor is null");
        }
        this.wifiAcq = wifiAcquisitor;
        this.geoAcq = geoAcquisitor;
        storeManager.clearOldPersistentData();
        this.eventTransmitter = new EventTransmitter(new EventServer(requestFactory), this.deviceContext, storeManager.createStorage());
        this.rtc = new RuntimeTriggerContainer(this.deviceContext, this.eventTransmitter, executor);
        WLRequest.addRequestPiggybacker(new DeviceContextPiggybacker(this.deviceContext));
    }

    public DeviceImpl(WifiAcquisitor wifiAcq, GeoAcquisitor geoAcquisitor, RuntimeTriggerContainer rtc, EventTransmitter eventTransmitter, PiggbackRegisterer registerer, ICallbackExecutor executor, Object object) {
        this.executor = executor;
        if (wifiAcq == null) {
            throw new IllegalArgumentException("wifiAcq is null");
        }
        if (eventTransmitter == null) {
            throw new IllegalArgumentException("eventTransmitter is null");
        }
        this.eventTransmitter = eventTransmitter;
        this.wifiAcq = wifiAcq;
        this.rtc = rtc;
        this.geoAcq = geoAcquisitor;
        registerer.register(new DeviceContextPiggybacker(this.deviceContext));
    }

    @Override
    public synchronized WLLocationServicesConfiguration getLocationServicesConfig() {
        return this.configuration.clone();
    }

    @Override
    public synchronized void startAcquisition(WLLocationServicesConfiguration newConfiguration) {
        this.valideParamNotNull(newConfiguration, NEW_CONFIGURATION);
        this.configuration = newConfiguration.clone();
        ArrayList<WLWifiFailureCallback> wifiFailureCallbacks = new ArrayList<WLWifiFailureCallback>();
        ArrayList<WLGeoFailureCallback> geoFailureCallbacks = new ArrayList<WLGeoFailureCallback>();
        for (WLAcquisitionFailureCallbacksConfiguration failureCallback : newConfiguration.getFailureCallbacks()) {
            if (failureCallback.getWifiFailureCallback() != null) {
                wifiFailureCallbacks.add(failureCallback.getWifiFailureCallback());
            }
            if (failureCallback.getGeoFailureCallback() == null) continue;
            geoFailureCallbacks.add(failureCallback.getGeoFailureCallback());
        }
        this.rtc.updateConfiguration(this.configuration);
        WLAcquisitionPolicy policy = this.configuration.getPolicy();
        if (policy == null) {
            this.stopGeo();
            this.stopWifi();
        } else {
            this.applyWifiPolicy(wifiFailureCallbacks, policy.getWifiPolicy());
            this.applyGeoPolicy(geoFailureCallbacks, policy.getGeoPolicy());
        }
    }

    private void applyWifiPolicy(List<WLWifiFailureCallback> wifiFailureCallbacks, WLWifiAcquisitionPolicy wifiPolicy) {
        if (wifiPolicy == null) {
            this.stopWifi();
        } else {
            if (this.deviceContext.getWifiLocation() == null) {
                this.deviceContext.setWifiPosition(new EmptyWifiPosition());
            }
            this.wifiAcq.startAcquisition(new RTCWifiLinker(this.rtc), new WifiErrorLinker(wifiFailureCallbacks, this.executor), wifiPolicy);
        }
    }

    private void applyGeoPolicy(List<WLGeoFailureCallback> geoFailureCallbacks, WLGeoAcquisitionPolicy geoPolicy) {
        if (geoPolicy == null) {
            this.stopGeo();
        } else {
            if (this.deviceContext.getGeoPosition() == null) {
                this.deviceContext.setGeoPosition(new EmptyGeoPosition());
            }
            this.geoAcq.startAcquisition(new RTCGeoLinker(this.rtc), new GeoErrorLinker(geoFailureCallbacks, this.executor), geoPolicy);
        }
    }

    @Override
    public void acquireGeoPosition(WLGeoCallback onSuccess, WLGeoFailureCallback onFailure, WLGeoAcquisitionPolicy geoPolicy) {
        this.valideParamNotNull(onSuccess, ON_SUCCESS);
        this.valideParamNotNull(onFailure, ON_FAILURE);
        this.valideParamNotNull(geoPolicy, GEO_POLICY);
        this.geoAcq.acquirePosition(new RTCGeoAcquireLinker(this, onSuccess, geoPolicy, this.executor), new GeoErrorLinker(Collections.singletonList(onFailure), this.executor), geoPolicy);
    }

    @Override
    public void acquireWifiVisibleAccessPoints(WLWifiAcquisitionCallback onSuccess, WLWifiFailureCallback onFailure, WLWifiAcquisitionPolicy wifiPolicy) {
        this.valideParamNotNull(onSuccess, ON_SUCCESS);
        this.valideParamNotNull(onFailure, ON_FAILURE);
        this.valideParamNotNull(wifiPolicy, WIFI_POLICY);
        this.wifiAcq.acquireLocation(new WifiAcquisitionCallbackConverter(onSuccess), new WifiErrorLinker(Collections.singletonList(onFailure), this.executor), wifiPolicy);
    }

    @Override
    public void getConnectedAccessPoint(WLWifiConnectedCallback onSuccess, WLWifiFailureCallback onFailure) {
        this.valideParamNotNull(onSuccess, ON_SUCCESS);
        this.valideParamNotNull(onFailure, ON_FAILURE);
        this.wifiAcq.acquireLocation(new WifiConnectedCallbackConverter(onSuccess), new WifiErrorLinker(Collections.singletonList(onFailure), this.executor), null);
    }

    private void valideParamNotNull(Object o, String paramName) {
        if (o == null) {
            throw new IllegalArgumentException(paramName + " can't be null");
        }
    }

    private void stopWifi() {
        this.wifiAcq.stopAcquisition();
        this.deviceContext.clearWifiPosition();
    }

    private void stopGeo() {
        this.geoAcq.stopAcquisition();
        this.deviceContext.clearGeoPosition();
    }

    @Override
    public synchronized void stopAcquisition() {
        this.stopWifi();
        this.stopGeo();
        this.rtc.clear();
    }

    @Override
    public WLDeviceContext getDeviceContext() {
        DeviceContextImpl result = this.deviceContext.clone();
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public EventTransmitter getEventTransmitter() {
        return this.eventTransmitter;
    }

    public DeviceContextImpl getDeviceContextImpl() {
        return this.deviceContext;
    }

    public RuntimeTriggerContainer getRTC() {
        return this.rtc;
    }

    public GeoAcquisitor getGeoAcquisitor() {
        return this.geoAcq;
    }
}

