/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal;

import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.api.wifi.WLWifiAccessPoint;
import com.worklight.location.api.wifi.WLWifiLocation;
import com.worklight.location.internal.DeviceContextImpl;
import com.worklight.location.internal.geo.EmptyGeoPosition;
import com.worklight.location.internal.wifi.EmptyWifiPosition;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceContextJSONFactory {
    DeviceContextJSONFactory() {
    }

    public JSONObject buildJson(DeviceContextImpl dc) throws JSONException {
        if (dc == null || dc.isEmpty()) {
            return null;
        }
        WLGeoPosition wLGeoPosition = dc.getGeoPosition();
        WLWifiLocation wifiPosition = dc.getWifiLocation();
        Integer timezoneOffset = dc.getTimezoneOffset();
        Long lastModified = dc.getLastModified();
        return DeviceContextJSONFactory.cleanNullValues(new JSONObject().put("lastModified", (Object)lastModified).put("timezoneOffset", (Object)timezoneOffset).put("Geo", (Object)DeviceContextJSONFactory.buildGeoJson(wLGeoPosition)).put("Wifi", (Object)DeviceContextJSONFactory.buildWifiJson(wifiPosition)));
    }

    private static JSONObject cleanNullValues(JSONObject o) throws JSONException {
        JSONObject result = new JSONObject();
        Iterator it = o.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = o.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private static JSONObject buildWifiJson(WLWifiLocation pos) throws JSONException {
        if (pos == null) {
            return null;
        }
        if (pos instanceof EmptyWifiPosition) {
            return new JSONObject();
        }
        return DeviceContextJSONFactory.cleanNullValues(new JSONObject().put("timestamp", (Object)pos.getTimestamp()).put("accessPoints", (Object)DeviceContextJSONFactory.buildAccessPointsJson(pos.getAccessPoints())).put("connectedAccessPoint", (Object)DeviceContextJSONFactory.buildAccessPointJson(pos.getConnectedAccessPoint())));
    }

    private static JSONArray buildAccessPointsJson(Collection<WLWifiAccessPoint> accessPoints) throws JSONException {
        JSONArray array = new JSONArray();
        for (WLWifiAccessPoint point : accessPoints) {
            array.put((Object)DeviceContextJSONFactory.buildAccessPointJson(point));
        }
        return array;
    }

    private static JSONObject buildAccessPointJson(WLWifiAccessPoint point) throws JSONException {
        if (point == null) {
            return null;
        }
        return DeviceContextJSONFactory.cleanNullValues(new JSONObject().put("SSID", (Object)point.getSSID()).put("MAC", (Object)point.getMAC()));
    }

    private static JSONObject buildGeoJson(WLGeoPosition pos) throws JSONException {
        if (pos == null) {
            return null;
        }
        if (pos instanceof EmptyGeoPosition) {
            return new JSONObject();
        }
        return DeviceContextJSONFactory.cleanNullValues(new JSONObject().put("timestamp", (Object)pos.getTimestamp()).put("coords", (Object)DeviceContextJSONFactory.buildCoordJson(pos.getCoordinate())));
    }

    private static JSONObject buildCoordJson(WLCoordinate coordinate) throws JSONException {
        return DeviceContextJSONFactory.cleanNullValues(new JSONObject().put("accuracy", coordinate.getAccuracy()).put("longitude", coordinate.getLongitude()).put("latitude", coordinate.getLatitude()).put("altitude", (Object)coordinate.getAltitude()).put("altitudeAccuracy", (Object)coordinate.getAltitudeAccuracy()).put("speed", (Object)coordinate.getSpeed()).put("heading", (Object)coordinate.getHeading()));
    }
}

