/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal;

import com.worklight.location.api.WLDeviceContext;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.api.wifi.WLWifiLocation;
import com.worklight.location.internal.AbstractPosition;
import com.worklight.location.internal.DeviceContextJSONFactory;
import com.worklight.location.internal.nativeImpl.LocationUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceContextImpl
implements WLDeviceContext,
Cloneable {
    private WLGeoPosition geoPosition = null;
    private WLWifiLocation wifiPosition = null;
    private Long lastModified = null;
    private Integer timezoneOffset = null;
    private long version = 0L;
    private static final DeviceContextJSONFactory jsonFactory = new DeviceContextJSONFactory();

    public synchronized DeviceContextImpl clone() {
        DeviceContextImpl clone = new DeviceContextImpl();
        clone.geoPosition = this.geoPosition;
        clone.wifiPosition = this.wifiPosition;
        clone.lastModified = this.lastModified;
        clone.timezoneOffset = this.timezoneOffset;
        clone.version = this.version;
        return clone;
    }

    @Override
    public WLGeoPosition getGeoPosition() {
        return this.geoPosition;
    }

    @Override
    public WLWifiLocation getWifiLocation() {
        return this.wifiPosition;
    }

    @Override
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Integer getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public synchronized void clearGeoPosition() {
        ++this.version;
        this.geoPosition = null;
        this.updateLastModified();
    }

    public synchronized void clearWifiPosition() {
        ++this.version;
        this.wifiPosition = null;
        this.updateLastModified();
    }

    public synchronized void setGeoPosition(WLGeoPosition wLGeoPosition) {
        if (wLGeoPosition == null) {
            throw new IllegalArgumentException("wLGeoPosition is null");
        }
        this.geoPosition = wLGeoPosition;
        this.updateLastModified();
    }

    public synchronized void setWifiPosition(WLWifiLocation wifiPosition) {
        if (wifiPosition == null) {
            throw new IllegalArgumentException("wifiPosition is null");
        }
        this.wifiPosition = wifiPosition;
        this.updateLastModified();
    }

    private void internalUpdateLastModified(AbstractPosition pos) {
        if (pos == null || pos.getTimestamp() == null) {
            return;
        }
        this.lastModified = this.lastModified == null ? pos.getTimestamp() : Long.valueOf(Math.max(this.lastModified, pos.getTimestamp()));
    }

    private synchronized void updateLastModified() {
        this.lastModified = null;
        this.internalUpdateLastModified(this.geoPosition);
        this.internalUpdateLastModified(this.wifiPosition);
        this.timezoneOffset = this.lastModified == null ? null : Integer.valueOf(-LocationUtils.getTimeZoneOffset());
        ++this.version;
    }

    public boolean isEmpty() {
        return this.geoPosition == null && this.wifiPosition == null;
    }

    @Override
    public JSONObject getJSON() {
        DeviceContextImpl clone = this.clone();
        try {
            return jsonFactory.buildJson(clone);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Override
    public void addToEvent(JSONObject event) {
        try {
            JSONObject dcJson = this.getJSON();
            event.put("deviceContext", dcJson == null ? JSONObject.NULL : dcJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geoPosition == null ? 0 : this.geoPosition.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.timezoneOffset == null ? 0 : this.timezoneOffset.hashCode());
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.wifiPosition == null ? 0 : this.wifiPosition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceContextImpl other = (DeviceContextImpl)obj;
        if (this.geoPosition == null ? other.geoPosition != null : !this.geoPosition.equals(other.geoPosition)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.timezoneOffset == null ? other.timezoneOffset != null : !this.timezoneOffset.equals(other.timezoneOffset)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return !(this.wifiPosition == null ? other.wifiPosition != null : !this.wifiPosition.equals(other.wifiPosition));
    }
}

