/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.wifi;

import com.worklight.location.api.wifi.WLWifiAccessPoint;
import com.worklight.location.internal.AbstractPosition;
import com.worklight.location.internal.wifi.AccessPointComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WLWifiLocation
extends AbstractPosition {
    private final List<WLWifiAccessPoint> accessPoints;
    private final WLWifiAccessPoint connectedAccessPoint;
    private final Integer connectedSignalStrength;

    public WLWifiLocation(Collection<WLWifiAccessPoint> accessPoints, WLWifiAccessPoint connectedAccessPoint, Integer connectedSignalStrength, long acquisitionTime) {
        super(acquisitionTime);
        if (accessPoints == null) {
            throw new IllegalArgumentException("accessPoints is null");
        }
        this.accessPoints = new ArrayList<WLWifiAccessPoint>(accessPoints);
        this.connectedAccessPoint = connectedAccessPoint;
        this.connectedSignalStrength = connectedSignalStrength;
        Collections.sort(this.accessPoints, new AccessPointComparator());
    }

    protected WLWifiLocation() {
        this.accessPoints = null;
        this.connectedAccessPoint = null;
        this.connectedSignalStrength = null;
    }

    public List<WLWifiAccessPoint> getAccessPoints() {
        return new ArrayList<WLWifiAccessPoint>(this.accessPoints);
    }

    public WLWifiAccessPoint getConnectedAccessPoint() {
        return this.connectedAccessPoint;
    }

    public Integer getConnectedSignalStrength() {
        return this.connectedSignalStrength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessPoints == null ? 0 : ((Object)this.accessPoints).hashCode());
        result = 31 * result + (this.connectedAccessPoint == null ? 0 : this.connectedAccessPoint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLWifiLocation other = (WLWifiLocation)obj;
        List<WLWifiAccessPoint> accessPoints = this.getAccessPoints();
        List<WLWifiAccessPoint> otherAccessPoints = other.getAccessPoints();
        if (accessPoints == null ? otherAccessPoints != null : !((Object)accessPoints).equals(otherAccessPoints)) {
            return false;
        }
        return !(this.connectedAccessPoint == null ? other.connectedAccessPoint != null : !this.connectedAccessPoint.equals(other.connectedAccessPoint));
    }

    public String toString() {
        return "WLWifiLocation: " + this.accessPoints.toString();
    }
}

