/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.wifi;

import com.worklight.location.api.wifi.WLWifiAccessPoint;

public class WLWifiAccessPointFilter {
    public static final String WILDCARD = "*";
    private final String ssid;
    private final String mac;

    public WLWifiAccessPointFilter(String ssid) {
        this(ssid, null);
    }

    public WLWifiAccessPointFilter(String ssid, String mac) {
        if (ssid == null) {
            throw new IllegalArgumentException("ssid is null");
        }
        this.ssid = ssid;
        this.mac = mac;
    }

    private static boolean matchesInternal(String filterString, String pointString) {
        return filterString == null || filterString.equals(WILDCARD) || filterString.equals(pointString);
    }

    public boolean matches(WLWifiAccessPoint point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null");
        }
        return WLWifiAccessPointFilter.matchesInternal(this.mac, point.getMAC()) && WLWifiAccessPointFilter.matchesInternal(this.ssid, point.getSSID());
    }

    public boolean isIntersectionNotEmpty(WLWifiAccessPointFilter filter) {
        return !(!WLWifiAccessPointFilter.matchesInternal(filter.mac, this.mac) && !WLWifiAccessPointFilter.matchesInternal(this.mac, filter.mac) || !WLWifiAccessPointFilter.matchesInternal(filter.ssid, this.ssid) && !WLWifiAccessPointFilter.matchesInternal(this.ssid, filter.ssid));
    }

    public String getMac() {
        return this.mac;
    }

    public String getSsid() {
        return this.ssid;
    }

    public String toString() {
        return String.format("Filter: (SSID: %s, MAC: %s)", this.ssid, this.mac);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.ssid == null ? 0 : this.ssid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLWifiAccessPointFilter other = (WLWifiAccessPointFilter)obj;
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        return !(this.ssid == null ? other.ssid != null : !this.ssid.equals(other.ssid));
    }
}

