/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.geo;

import com.worklight.location.api.geo.WLArea;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.internal.geo.AreaVisitor;
import java.util.ArrayList;
import java.util.List;

public class WLPolygon
implements WLArea {
    private final List<WLCoordinate> coordinates;
    public final int length;

    public WLPolygon(List<WLCoordinate> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates was null");
        }
        if (coordinates.isEmpty()) {
            throw new IllegalArgumentException("coordinates list was empty");
        }
        this.coordinates = new ArrayList<WLCoordinate>(coordinates);
        this.length = coordinates.size();
    }

    public List<WLCoordinate> getCoordinates() {
        return new ArrayList<WLCoordinate>(this.coordinates);
    }

    public String toString() {
        return "WLPolygon: " + this.coordinates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordinates == null ? 0 : ((Object)this.coordinates).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLPolygon other = (WLPolygon)obj;
        return !(this.coordinates == null ? other.coordinates != null : !((Object)this.coordinates).equals(other.coordinates));
    }

    public WLCoordinate get(int idx) {
        return this.coordinates.get(idx);
    }

    @Override
    public Object accept(AreaVisitor visitor) {
        return visitor.visitPolygon(this);
    }
}

