/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.geo;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.geo.WLArea;
import com.worklight.location.api.geo.WLCircle;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLPolygon;
import com.worklight.location.internal.InternalGeoUtils;
import com.worklight.location.internal.geo.GetDistanceToAreaVisitor;
import com.worklight.location.internal.geo.IsInsideAreaVisitor;
import com.worklight.location.internal.geo.IsOutsideAreaVisitor;

public class WLGeoUtils {
    public static double getDistanceBetweenCoordinates(WLCoordinate coordinate1, WLCoordinate coordinate2) {
        double lon1 = coordinate1.getLongitude();
        double lat1 = coordinate1.getLatitude();
        double lon2 = coordinate2.getLongitude();
        double lat2 = coordinate2.getLatitude();
        double dLon = lon2 - lon1;
        if (Math.abs(dLon) > 180.0) {
            dLon = InternalGeoUtils.transformLongitude(lon2) - InternalGeoUtils.transformLongitude(lon1);
        }
        dLon = InternalGeoUtils.radians(dLon);
        double dLat = InternalGeoUtils.radians(lat2 - lat1);
        double calc = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(InternalGeoUtils.radians(lat1)) * Math.cos(InternalGeoUtils.radians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(calc), Math.sqrt(1.0 - calc));
        return InternalGeoUtils.radiansToMeters(c);
    }

    public static double getDistanceToCircle(WLCoordinate coordinate, WLCircle circle) {
        return WLGeoUtils.getDistanceToCircle(coordinate, circle, 0.0);
    }

    public static double getDistanceToCircle(WLCoordinate coordinate, WLCircle circle, double bufferZoneWidth) {
        if (bufferZoneWidth < 0.0 && -bufferZoneWidth > circle.getRadius()) {
            throw new ArithmeticException(String.format("bufferedZoneWidth (%f) is negative and its absolute value is larger than the circle's radius (%f)", bufferZoneWidth, circle.getRadius()));
        }
        return WLGeoUtils.getDistanceBetweenCoordinates(circle.getCenter(), coordinate) - circle.getRadius() - bufferZoneWidth;
    }

    public static boolean isInsideCircle(WLCoordinate coordinate, WLCircle circle) {
        return WLGeoUtils.isInsideCircle(coordinate, circle, 0.0, WLConfidenceLevel.LOW);
    }

    public static boolean isInsideCircle(WLCoordinate coordinate, WLCircle circle, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        double distanceToCircle = WLGeoUtils.getDistanceToCircle(coordinate, circle, bufferZoneWidth);
        return distanceToCircle <= 0.0 && InternalGeoUtils.isDistanceWithinConfidenceLevel(-distanceToCircle, confidenceLevel, coordinate.getAccuracy());
    }

    public static boolean isOutsideCircle(WLCoordinate coordinate, WLCircle circle) {
        return WLGeoUtils.isOutsideCircle(coordinate, circle, 0.0, WLConfidenceLevel.LOW);
    }

    public static boolean isOutsideCircle(WLCoordinate coordinate, WLCircle circle, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        double distanceToCircle = WLGeoUtils.getDistanceToCircle(coordinate, circle, bufferZoneWidth);
        return distanceToCircle > 0.0 && InternalGeoUtils.isDistanceWithinConfidenceLevel(distanceToCircle, confidenceLevel, coordinate.getAccuracy());
    }

    public static double getDistanceToPolygon(WLCoordinate coordinate, WLPolygon polygon) {
        return WLGeoUtils.getDistanceToPolygon(coordinate, polygon, 0.0);
    }

    public static double getDistanceToPolygon(WLCoordinate coordinate, WLPolygon polygon, double bufferZoneWidth) {
        double distanceToBoundary = Double.MAX_VALUE;
        WLPolygon oldPolygon = polygon;
        WLPolygon newPolygon = InternalGeoUtils.transformPolygon(polygon);
        WLCoordinate newCoordinate = coordinate;
        if (!oldPolygon.equals(newPolygon)) {
            newCoordinate = InternalGeoUtils.transformCoordinate(coordinate);
        }
        int numOfPoints = newPolygon.getCoordinates().size();
        for (int i = 0; i < numOfPoints; ++i) {
            WLCoordinate nextCoordinate;
            WLCoordinate currentCoordinate = newPolygon.getCoordinates().get(i);
            double currentDistance = InternalGeoUtils.distanceFromLineSegment(newCoordinate, currentCoordinate, nextCoordinate = newPolygon.getCoordinates().get((i + 1) % numOfPoints));
            if (!(currentDistance < distanceToBoundary)) continue;
            distanceToBoundary = currentDistance;
        }
        distanceToBoundary = InternalGeoUtils.isInsidePolygonBoundary(newCoordinate, newPolygon) ? -(distanceToBoundary + bufferZoneWidth) : (distanceToBoundary -= bufferZoneWidth);
        return distanceToBoundary;
    }

    public static boolean isInsidePolygon(WLCoordinate coordinate, WLPolygon polygon) {
        return WLGeoUtils.isInsidePolygon(coordinate, polygon, 0.0, WLConfidenceLevel.LOW);
    }

    public static boolean isInsidePolygon(WLCoordinate coordinate, WLPolygon polygon, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        double distanceToPolygon = WLGeoUtils.getDistanceToPolygon(coordinate, polygon, bufferZoneWidth);
        return distanceToPolygon <= 0.0 && InternalGeoUtils.isDistanceWithinConfidenceLevel(-distanceToPolygon, confidenceLevel, coordinate.getAccuracy());
    }

    public static boolean isOutsidePolygon(WLCoordinate coordinate, WLPolygon polygon, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        double distanceToPolygon = WLGeoUtils.getDistanceToPolygon(coordinate, polygon, bufferZoneWidth);
        return distanceToPolygon > 0.0 && InternalGeoUtils.isDistanceWithinConfidenceLevel(distanceToPolygon, confidenceLevel, coordinate.getAccuracy());
    }

    public static boolean isOutsidePolygon(WLCoordinate coordinate, WLPolygon polygon) {
        return WLGeoUtils.isOutsideArea(coordinate, polygon, 0.0, WLConfidenceLevel.LOW);
    }

    public static boolean isInsideArea(WLCoordinate coordinate, WLArea area, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        return (Boolean)area.accept(new IsInsideAreaVisitor(coordinate, confidenceLevel, bufferZoneWidth));
    }

    public static boolean isInsideArea(WLCoordinate coordinate, WLArea area) {
        return WLGeoUtils.isInsideArea(coordinate, area, 0.0, WLConfidenceLevel.LOW);
    }

    public static boolean isOutsideArea(WLCoordinate coordinate, WLArea area, double bufferZoneWidth, WLConfidenceLevel confidenceLevel) {
        return (Boolean)area.accept(new IsOutsideAreaVisitor(confidenceLevel, coordinate, bufferZoneWidth));
    }

    public static boolean isOutsideArea(WLCoordinate coordinate, WLArea area) {
        return WLGeoUtils.isOutsideArea(coordinate, area, 0.0, WLConfidenceLevel.LOW);
    }

    public static double getDistanceToArea(WLCoordinate coordinate, WLArea area) {
        return WLGeoUtils.getDistanceToArea(coordinate, area, 0.0);
    }

    public static double getDistanceToArea(WLCoordinate coordinate, WLArea area, double bufferZoneWidth) {
        return (Double)area.accept(new GetDistanceToAreaVisitor(coordinate, bufferZoneWidth));
    }
}

