/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.geo;

public class WLGeoAcquisitionPolicy
implements Cloneable {
    private static final long MIN_MAXIMUM_AGE = 100L;
    private long maximumAge = 100L;
    private long timeout = -1L;
    private boolean enableHighAccuracy = false;
    private int desiredAccuracy = 0;
    private int minChangeDistance = 0;
    private int minChangeTime = 0;

    public static WLGeoAcquisitionPolicy getPowerSavingProfile() {
        return new WLGeoAcquisitionPolicy().setEnableHighAccuracy(false).setMinChangeTime(300000).setMinChangeDistance(1000).setMaximumAge(300000L);
    }

    public static WLGeoAcquisitionPolicy getRoughTrackingProfile() {
        return new WLGeoAcquisitionPolicy().setEnableHighAccuracy(true).setDesiredAccuracy(200).setMinChangeTime(30000).setMinChangeDistance(50).setMaximumAge(60000L);
    }

    public static WLGeoAcquisitionPolicy getLiveTrackingProfile() {
        return new WLGeoAcquisitionPolicy().setEnableHighAccuracy(true).setMaximumAge(100L);
    }

    public double getMaximumAge() {
        return this.maximumAge;
    }

    public WLGeoAcquisitionPolicy setMaximumAge(long maximumAge) {
        if (maximumAge > 100L) {
            this.maximumAge = maximumAge;
        }
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public WLGeoAcquisitionPolicy setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isEnableHighAccuracy() {
        return this.enableHighAccuracy;
    }

    public WLGeoAcquisitionPolicy setEnableHighAccuracy(boolean enableHighAccuracy) {
        this.enableHighAccuracy = enableHighAccuracy;
        return this;
    }

    public int getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public WLGeoAcquisitionPolicy setDesiredAccuracy(int desiredAccuracy) {
        this.desiredAccuracy = desiredAccuracy;
        return this;
    }

    public int getMinChangeDistance() {
        return this.minChangeDistance;
    }

    public WLGeoAcquisitionPolicy setMinChangeDistance(int minChangeDistance) {
        if (this.enableHighAccuracy && minChangeDistance > 0) {
            this.minChangeDistance = minChangeDistance;
        }
        return this;
    }

    public int getMinChangeTime() {
        return this.minChangeTime;
    }

    public WLGeoAcquisitionPolicy setMinChangeTime(int minChangeTime) {
        if (this.enableHighAccuracy && minChangeTime > 0) {
            this.minChangeTime = minChangeTime;
        }
        return this;
    }

    public WLGeoAcquisitionPolicy clone() {
        return new WLGeoAcquisitionPolicy().setEnableHighAccuracy(this.enableHighAccuracy).setDesiredAccuracy(this.desiredAccuracy).setMaximumAge(this.maximumAge).setMinChangeDistance(this.minChangeDistance).setMinChangeTime(this.minChangeTime).setTimeout(this.timeout);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.desiredAccuracy;
        result = 31 * result + (this.enableHighAccuracy ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.maximumAge);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.minChangeDistance;
        result = 31 * result + this.minChangeTime;
        temp = Double.doubleToLongBits(this.timeout);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLGeoAcquisitionPolicy other = (WLGeoAcquisitionPolicy)obj;
        if (this.desiredAccuracy != other.desiredAccuracy) {
            return false;
        }
        if (this.enableHighAccuracy != other.enableHighAccuracy) {
            return false;
        }
        if (Double.doubleToLongBits(this.maximumAge) != Double.doubleToLongBits(other.maximumAge)) {
            return false;
        }
        if (this.minChangeDistance != other.minChangeDistance) {
            return false;
        }
        if (this.minChangeTime != other.minChangeTime) {
            return false;
        }
        return Double.doubleToLongBits(this.timeout) == Double.doubleToLongBits(other.timeout);
    }
}

