/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.geo;

public class WLCoordinate {
    private final double latitude;
    private final double longitude;
    private final double accuracy;
    private final Double altitude;
    private final Double altitudeAccuracy;
    private final Double heading;
    private final Double speed;

    public WLCoordinate(double latitude, double longitude) {
        this(latitude, longitude, null, 0.0, null, null, null);
    }

    public WLCoordinate(double latitude, double longitude, double accuracy) {
        this(latitude, longitude, null, accuracy, null, null, null);
    }

    public WLCoordinate(double latitude, double longitude, Double altitude, double accuracy, Double altitudeAccuracy, Double heading, Double speed) {
        double tempLat = latitude % 360.0;
        double tempLong = longitude % 360.0;
        if (tempLat < -90.0 && tempLat > -270.0) {
            tempLat = -180.0 - tempLat;
            tempLong += 180.0;
        } else if (tempLat < -270.0) {
            tempLat += 360.0;
        }
        if (tempLat > 90.0 && tempLat < 270.0) {
            tempLat = 180.0 - tempLat;
            tempLong += 180.0;
        } else if (tempLat > 270.0) {
            tempLat -= 360.0;
        }
        if (tempLong > 180.0) {
            tempLong = -360.0 + tempLong;
        }
        if (tempLong < -180.0) {
            tempLong = 360.0 + tempLong;
        }
        assert (Math.abs(tempLat) <= 90.0);
        assert (Math.abs(tempLong) <= 180.0);
        this.latitude = tempLat;
        this.longitude = tempLong;
        if (accuracy < 0.0) {
            throw new IllegalArgumentException("accuracy must be non-negative, was " + accuracy);
        }
        this.accuracy = accuracy;
        if (altitude != null && altitude < 0.0) {
            throw new IllegalArgumentException("altitude must be non-negative, was " + altitude);
        }
        this.altitude = altitude;
        if (altitudeAccuracy != null && altitudeAccuracy < 0.0) {
            throw new IllegalArgumentException("altitudeAccuracy must be non-negative, was " + altitudeAccuracy);
        }
        this.altitudeAccuracy = altitudeAccuracy;
        if (heading != null && (heading < 0.0 || heading >= 360.0)) {
            throw new IllegalArgumentException("heading must conform to: 0 <= heading < 360, was " + altitudeAccuracy);
        }
        this.heading = heading;
        if (speed != null && speed < 0.0) {
            throw new IllegalArgumentException("speed must be non-negative, was " + speed);
        }
        this.speed = speed;
    }

    public String toString() {
        return String.format("(%f,%f)", this.latitude, this.longitude) + (this.accuracy != 0.0 ? " ~" + this.accuracy : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.accuracy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.altitude == null ? 0 : this.altitude.hashCode());
        result = 31 * result + (this.altitudeAccuracy == null ? 0 : this.altitudeAccuracy.hashCode());
        result = 31 * result + (this.heading == null ? 0 : this.heading.hashCode());
        temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.speed == null ? 0 : this.speed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLCoordinate other = (WLCoordinate)obj;
        if (Double.doubleToLongBits(this.accuracy) != Double.doubleToLongBits(other.accuracy)) {
            return false;
        }
        if (this.altitude == null ? other.altitude != null : !this.altitude.equals(other.altitude)) {
            return false;
        }
        if (this.altitudeAccuracy == null ? other.altitudeAccuracy != null : !this.altitudeAccuracy.equals(other.altitudeAccuracy)) {
            return false;
        }
        if (this.heading == null ? other.heading != null : !this.heading.equals(other.heading)) {
            return false;
        }
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        return !(this.speed == null ? other.speed != null : !this.speed.equals(other.speed));
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Double getAltitudeAccuracy() {
        return this.altitudeAccuracy;
    }

    public Double getHeading() {
        return this.heading;
    }

    public Double getSpeed() {
        return this.speed;
    }
}

