/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.api.geo;

import com.worklight.location.api.geo.WLArea;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.internal.geo.AreaVisitor;

public class WLCircle
implements WLArea {
    private final double radius;
    private final WLCoordinate center;

    public WLCircle(WLCoordinate center, double radius) {
        if (center == null) {
            throw new IllegalArgumentException("center is null");
        }
        if (radius < 0.0) {
            throw new IllegalArgumentException("radius must be non-negative, was " + radius);
        }
        this.center = center;
        this.radius = radius;
    }

    public int hashCode() {
        int prime = 31;
        double result = 1.0;
        result = 31.0 * result + (double)(this.getCenter() == null ? 0 : this.getCenter().hashCode());
        result = 31.0 * result + this.getRadius();
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WLCircle other = (WLCircle)obj;
        if (this.getCenter() == null ? other.getCenter() != null : !this.getCenter().equals(other.getCenter())) {
            return false;
        }
        return this.getRadius() == other.getRadius();
    }

    @Override
    public Object accept(AreaVisitor visitor) {
        return visitor.visitCircle(this);
    }

    public double getRadius() {
        return this.radius;
    }

    public WLCoordinate getCenter() {
        return this.center;
    }
}

