/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.util;

import com.worklight.jsonstore.util.JSONStoreLogger;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreUtil {
    private static final String[] DATABASE_SPECIAL_CHARACTERS = new String[]{"@", "$", "^", "&", "|", ">", "<", "?", "-"};
    private static final JSONStoreLogger coreLogger = JSONStoreLogger.getLogger("jsonstore-core");
    private static final JSONStoreLogger dbLogger = JSONStoreLogger.getLogger("jsonstore-db");

    private JSONStoreUtil() {
    }

    public static JSONStoreLogger getCoreLogger() {
        return coreLogger;
    }

    public static JSONStoreLogger getDatabaseLogger() {
        return dbLogger;
    }

    public static String formatString(String pattern, Object ... args) {
        return MessageFormat.format(pattern, args);
    }

    public static List<List<Integer>> splitListIntoChunks(List<Integer> arr, int chunk_size) {
        LinkedList<List<Integer>> list = new LinkedList<List<Integer>>();
        int start = 0;
        int count = arr.size();
        if (count <= chunk_size) {
            list.add(arr);
        } else {
            while (count > 0) {
                int numToCopy = Math.min(chunk_size, arr.size() - start);
                list.add(arr.subList(start, start + numToCopy));
                start += chunk_size;
                count -= chunk_size;
            }
        }
        return list;
    }

    public static List<JSONObject> convertJSONArrayToJSONObjectList(JSONArray arr) {
        LinkedList<JSONObject> results = new LinkedList<JSONObject>();
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    results.add(arr.getJSONObject(i));
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return results;
    }

    public static List<JSONObject> convertJSONObjectArrayToJSONObjectList(JSONObject[] arr) {
        LinkedList<JSONObject> results = new LinkedList<JSONObject>();
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                JSONObject obj = arr[i];
                results.add(obj);
            }
        }
        return results;
    }

    public static JSONArray convertJSONObjectListToJSONArray(List<JSONObject> objs) {
        JSONArray out = new JSONArray();
        if (objs == null) {
            return out;
        }
        for (JSONObject obj : objs) {
            if (obj == null) continue;
            out.put((Object)obj);
        }
        return out;
    }

    public static String getDatabaseSafeSearchFieldName(String name) {
        if (name == null) {
            return null;
        }
        for (String ch : DATABASE_SPECIAL_CHARACTERS) {
            name = name.replace(ch, "");
        }
        String res = name.replace('.', '_');
        return res;
    }
}

