/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.util;

import com.worklight.common.Logger;
import com.worklight.jsonstore.api.JSONStoreFileInfo;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreLogger {
    private static Logger logger = Logger.getInstance("JSONSTORE");
    private static Logger analyticsLogger = Logger.getInstance("JSONSTORE_ANALYTICS");
    private static boolean analyticsEnabled = false;
    private static final String ANALYTICS_SOURCE = "java";
    private static final String ANALYTICS_RETURN_CODE = "$js.rc";
    private static final String ANALYTICS_OPERATION = "$js.operation";
    private static final String ANALYTICS_COLLECTION = "$js.collection";
    private static final String ANALYTICS_USERNAME = "$js.user";
    private static final String ANALYTICS_END_TIME = "$js.endTime";
    private static final String ANALYTICS_START_TIME = "$js.startTime";
    private static final String ANALYTICS_SOURCE_KEY = "$src";
    private static final String ANALYTICS_SIZE = "$js.size";
    private static final String ANALYTICS_IS_ENCRYPTED = "$js.encryption";
    public static String OPERATION_OPEN = "open";
    public static String OPERATION_CLOSE_ALL = "closeAll";
    public static String OPERATION_CHANGE_PASSWORD = "changePassword";
    public static String OPERATION_DESTROY = "destroy";
    public static String OPERATION_START_TRANSACTION = "startTransaction";
    public static String OPERATION_COMMIT_TRANSACTION = "commitTransaction";
    public static String OPERATION_ROLLBACK_TRANSACTION = "rollbackTransaction";
    public static String OPERATION_ADD = "add";
    public static String OPERATION_IS_DOCUMENT_DIRTY = "isDirty";
    public static String OPERATION_COUNT_ALL_DIRTY = "countAllDirty";
    public static String OPERATION_MARK_CLEAN = "markClean";
    public static String OPERATION_REMOVE_COLLECTION = "removeCollection";
    public static String OPERATION_COUNT = "count";
    public static String OPERATION_REMOVE = "remove";
    public static String OPERATION_REPLACE = "replace";
    public static String OPERATION_FIND = "find";
    public static String OPERATION_CLEAR = "clear";
    public static String OPERATION_CHANGE = "change";
    public static String OPERATION_FIND_ALL_DIRTY = "allDirty";
    private static final HashMap<String, JSONStoreLogger> instances = new HashMap();
    private String tag;

    private JSONStoreLogger(String tag) {
        this.tag = tag;
    }

    public static synchronized JSONStoreLogger getLogger(String name) {
        JSONStoreLogger logger = instances.get(name);
        if (logger == null) {
            logger = new JSONStoreLogger(name);
            instances.put(name, logger);
        }
        return logger;
    }

    public void logDebug(String message) {
        LogDetails details = new LogDetails(this.tag, "debug", message, null);
        logger.debug(message, details.convertToMetadata());
    }

    public void logDebug(String message, Throwable error) {
        LogDetails details = new LogDetails(this.tag, "debug", message, error);
        logger.debug(message, details.convertToMetadata());
    }

    public void logError(String message) {
        LogDetails details = new LogDetails(this.tag, "error", message, null);
        logger.error(message, details.convertToMetadata());
    }

    public void logError(String message, Throwable error) {
        LogDetails details = new LogDetails(this.tag, "error", message, error);
        logger.error(message, details.convertToMetadata(), error);
    }

    public void logTrace(String message) {
        LogDetails details = new LogDetails(this.tag, "info", message, null);
        logger.trace(message, details.convertToMetadata());
    }

    public static JSONStoreAnalyticsLogInstance startAnalyticsInstance(String username, String collection, String operation) {
        return new JSONStoreAnalyticsLogInstance(username, collection, operation);
    }

    public static void logAnalytics(Long startTime, Long endTime, String username, String collection, String operation) {
        if (!analyticsEnabled) {
            return;
        }
        String analyticsMessage = "";
        JSONObject metadata = new JSONObject();
        try {
            metadata.put(ANALYTICS_SOURCE_KEY, (Object)ANALYTICS_SOURCE);
            metadata.put(ANALYTICS_START_TIME, (Object)startTime);
            metadata.put(ANALYTICS_END_TIME, (Object)endTime);
            metadata.put(ANALYTICS_USERNAME, (Object)username);
            metadata.put(ANALYTICS_COLLECTION, (Object)collection);
            metadata.put(ANALYTICS_OPERATION, (Object)operation);
            metadata.put(ANALYTICS_RETURN_CODE, 0);
        }
        catch (JSONException e) {
            analyticsLogger.error("Error logging JSONStore analytics.", e);
        }
        analyticsLogger.analytics(analyticsMessage, metadata);
    }

    public static void setAnalyticsEnabled(boolean enabled) {
        analyticsEnabled = enabled;
    }

    public static void logFileInfo(List<JSONStoreFileInfo> fileInfoList) {
        if (!analyticsEnabled) {
            return;
        }
        for (JSONStoreFileInfo fileInfo : fileInfoList) {
            String analyticsMessage = "";
            JSONObject metadata = new JSONObject();
            try {
                metadata.put(ANALYTICS_SOURCE_KEY, (Object)ANALYTICS_SOURCE);
                metadata.put(ANALYTICS_USERNAME, (Object)fileInfo.getUsername());
                metadata.put(ANALYTICS_SIZE, fileInfo.getFileSizeBytes());
                metadata.put(ANALYTICS_IS_ENCRYPTED, fileInfo.isEncrypted());
                metadata.put(ANALYTICS_RETURN_CODE, 0);
            }
            catch (JSONException e) {
                analyticsLogger.error("Error logging JSONStore analytics.", e);
            }
            analyticsLogger.analytics(analyticsMessage, metadata);
        }
    }

    public static class JSONStoreAnalyticsLogInstance {
        private long startTime = System.currentTimeMillis();
        private String username;
        private String collection;
        private String operation;

        public JSONStoreAnalyticsLogInstance(String username, String collection, String operation) {
            this.username = username;
            this.collection = collection;
            this.operation = operation;
        }

        public void end() {
            long endTime = System.currentTimeMillis();
            JSONStoreLogger.logAnalytics(this.startTime, endTime, this.username, this.collection, this.operation);
        }
    }

    public static class LogDetails {
        StackTraceElement[] stackTrace;
        Throwable cause;
        long timeLogged;
        String message;
        String tag;
        String type;

        public LogDetails(String tag, String type, String message, Throwable cause) {
            this.tag = tag;
            this.type = type;
            this.message = message;
            this.cause = cause;
            this.timeLogged = System.currentTimeMillis() / 1000L;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }

        public JSONArray convertStackTraceElementToJSONArray(StackTraceElement[] elements) {
            JSONArray arr = new JSONArray();
            try {
                for (StackTraceElement element : elements) {
                    JSONObject elementJSON = new JSONObject();
                    elementJSON.put("line", element.getLineNumber());
                    elementJSON.put("class", (Object)element.getClassName());
                    elementJSON.put("method", (Object)element.getMethodName());
                    elementJSON.put("file", (Object)element.getFileName());
                    arr.put((Object)elementJSON);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return arr;
        }

        public JSONObject convertThrowableToJSONObject(Throwable t) {
            JSONObject throwObj = new JSONObject();
            try {
                JSONArray stackTrace = this.convertStackTraceElementToJSONArray(t.getStackTrace());
                throwObj.put("throwableStackTrace", (Object)stackTrace);
                throwObj.put("message", (Object)t.getMessage());
                throwObj.put("tag", (Object)this.tag);
                throwObj.put("type", (Object)this.type);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return throwObj;
        }

        public JSONObject convertToMetadata() {
            JSONObject metadata = new JSONObject();
            try {
                metadata.put("message", (Object)this.message);
                metadata.put("time", this.timeLogged);
                if (this.cause != null) {
                    metadata.put("causedBy", (Object)this.convertThrowableToJSONObject(this.cause));
                }
                metadata.put("stackTrace", (Object)this.convertStackTraceElementToJSONArray(this.stackTrace));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return metadata;
        }
    }
}

