/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.jackson;

import com.worklight.jsonstore.jackson.JsonOrgJSONArrayDeserializer;
import com.worklight.jsonstore.jackson.JsonOrgJSONArraySerializer;
import com.worklight.jsonstore.jackson.JsonOrgJSONObjectDeserializer;
import com.worklight.jsonstore.jackson.JsonOrgJSONObjectSerializer;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonOrgModule
extends SimpleModule {
    private static final ObjectMapper mapper = new ObjectMapper();

    private JsonOrgModule() {
        super("JsonOrgModule", new Version(1, 0, 0, null));
        this.addDeserializer(JSONArray.class, (JsonDeserializer)JsonOrgJSONArrayDeserializer.instance);
        this.addDeserializer(JSONObject.class, (JsonDeserializer)JsonOrgJSONObjectDeserializer.instance);
        this.addSerializer(JSONArray.class, (JsonSerializer)JsonOrgJSONArraySerializer.instance);
        this.addSerializer(JSONObject.class, (JsonSerializer)JsonOrgJSONObjectSerializer.instance);
    }

    public static JSONArray deserializeJSONArray(String json) throws Throwable {
        return (JSONArray)mapper.readValue(json, JSONArray.class);
    }

    public static JSONObject deserializeJSONObject(String json) throws Throwable {
        return (JSONObject)mapper.readValue(json, JSONObject.class);
    }

    public static String serialize(JSONArray array) {
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)array);
            writer.close();
            return writer.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String serialize(JSONObject obj) {
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)obj);
            writer.close();
            return writer.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        mapper.registerModule((Module)new JsonOrgModule());
    }
}

