/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.jackson;

import com.worklight.jsonstore.jackson.JsonOrgJSONArraySerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonOrgJSONObjectSerializer
extends SerializerBase<JSONObject> {
    public static final JsonOrgJSONObjectSerializer instance = new JsonOrgJSONObjectSerializer();

    public JsonOrgJSONObjectSerializer() {
        super(JSONObject.class);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    public void serialize(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    protected void serializeContents(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Iterator i = value.keys();
        while (i.hasNext()) {
            Object obj;
            String key = (String)i.next();
            try {
                obj = value.get(key);
            }
            catch (JSONException e) {
                throw new JsonGenerationException((Throwable)e);
            }
            if (obj == null || obj == JSONObject.NULL) {
                jgen.writeNullField(key);
                continue;
            }
            jgen.writeFieldName(key);
            Class<?> cls = obj.getClass();
            if (cls == JSONObject.class || JSONObject.class.isAssignableFrom(cls)) {
                this.serialize((JSONObject)obj, jgen, provider);
                continue;
            }
            if (cls == JSONArray.class || JSONArray.class.isAssignableFrom(cls)) {
                JsonOrgJSONArraySerializer.instance.serialize((JSONArray)obj, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)obj);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)obj).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)obj).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)obj).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)obj).doubleValue());
                continue;
            }
            provider.defaultSerializeValue(obj, jgen);
        }
    }

    public void serializeWithType(JSONObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }
}

