/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.jackson;

import com.worklight.jsonstore.jackson.JacksonSerializedJSONObject;
import com.worklight.jsonstore.jackson.JsonOrgJSONArrayDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonOrgJSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    protected static final JsonOrgJSONObjectDeserializer instance = new JsonOrgJSONObjectDeserializer();

    protected JsonOrgJSONObjectDeserializer() {
        super(JSONObject.class);
    }

    public JSONObject deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JacksonSerializedJSONObject result = new JacksonSerializedJSONObject();
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_OBJECT) {
            token = parser.nextToken();
        }
        try {
            while (token != JsonToken.END_OBJECT) {
                if (token != JsonToken.FIELD_NAME) {
                    throw context.wrongTokenException(parser, JsonToken.FIELD_NAME, "");
                }
                String name = parser.getCurrentName();
                token = parser.nextToken();
                switch (token) {
                    case START_ARRAY: {
                        result.put(name, JsonOrgJSONArrayDeserializer.instance.deserialize(parser, context));
                        break;
                    }
                    case START_OBJECT: {
                        result.put(name, this.deserialize(parser, context));
                        break;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        result.put(name, parser.getEmbeddedObject());
                        break;
                    }
                    case VALUE_FALSE: {
                        result.put(name, Boolean.FALSE);
                        break;
                    }
                    case VALUE_NULL: {
                        result.put(name, JSONObject.NULL);
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        result.put(name, parser.getNumberValue());
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        result.put(name, parser.getNumberValue());
                        break;
                    }
                    case VALUE_STRING: {
                        result.put(name, parser.getText());
                        break;
                    }
                    case VALUE_TRUE: {
                        result.put(name, Boolean.TRUE);
                        break;
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (JSONException e) {
            throw context.mappingException(e.getMessage());
        }
        return result;
    }
}

