/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.jackson;

import com.worklight.jsonstore.jackson.JsonOrgJSONObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonOrgJSONArraySerializer
extends SerializerBase<JSONArray> {
    public static final JsonOrgJSONArraySerializer instance = new JsonOrgJSONArraySerializer();

    protected JsonOrgJSONArraySerializer() {
        super(JSONArray.class);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    public void serialize(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndArray();
    }

    private void serializeContents(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            Object obj = value.opt(i);
            if (obj == null || obj == JSONObject.NULL) {
                jgen.writeNull();
                continue;
            }
            Class<?> cls = obj.getClass();
            if (cls == JSONObject.class || JSONObject.class.isAssignableFrom(cls)) {
                JsonOrgJSONObjectSerializer.instance.serialize((JSONObject)obj, jgen, provider);
                continue;
            }
            if (cls == JSONArray.class || JSONArray.class.isAssignableFrom(cls)) {
                this.serialize((JSONArray)obj, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)obj);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)obj).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)obj).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)obj).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)obj).doubleValue());
                continue;
            }
            provider.defaultSerializeValue(obj, jgen);
        }
    }

    public void serializeWithType(JSONArray value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForArray((Object)value, jgen);
    }
}

