/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.jackson;

import com.worklight.jsonstore.jackson.JacksonSerializedJSONArray;
import com.worklight.jsonstore.jackson.JsonOrgJSONObjectDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonOrgJSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    protected static final JsonOrgJSONArrayDeserializer instance = new JsonOrgJSONArrayDeserializer();

    protected JsonOrgJSONArrayDeserializer() {
        super(JSONArray.class);
    }

    public JSONArray deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JacksonSerializedJSONArray result = new JacksonSerializedJSONArray();
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            switch (token) {
                case START_ARRAY: {
                    result.put(this.deserialize(parser, context));
                    break;
                }
                case START_OBJECT: {
                    result.put(JsonOrgJSONObjectDeserializer.instance.deserialize(parser, context));
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    result.put(parser.getEmbeddedObject());
                    break;
                }
                case VALUE_FALSE: {
                    result.put(Boolean.FALSE);
                    break;
                }
                case VALUE_NULL: {
                    result.put(JSONObject.NULL);
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result.put(parser.getNumberValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result.put(parser.getNumberValue());
                    break;
                }
                case VALUE_STRING: {
                    result.put(parser.getText());
                    break;
                }
                case VALUE_TRUE: {
                    result.put(Boolean.TRUE);
                    break;
                }
            }
            token = parser.nextToken();
        }
        return result;
    }
}

