/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import android.content.ContentValues;
import android.database.Cursor;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.database.ReadableDatabase;
import com.worklight.jsonstore.jackson.JacksonSerializedJSONObject;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sqlcipher.database.SQLiteDatabase;
import org.json.JSONException;
import org.json.JSONObject;

public class WritableDatabase
extends ReadableDatabase {
    private static final String SQL_AND = " AND";
    private static final String SQL_DELETE = "DELETE FROM {0} WHERE {1};";
    private static final String SQL_INSERT = "INSERT INTO {0} ({1}) VALUES ({2});";
    private static final String SQL_UPDATE = "UPDATE {0} SET {1}{2};";
    private static final String SQL_WHERE = " WHERE";

    protected WritableDatabase(SQLiteDatabase database, DatabaseSchema schema) {
        super(database, schema);
    }

    public int delete(String[] whereClause, Object[] whereValues) {
        int i;
        String dbName = this.getSchema().getName();
        StringBuilder whereClauseStr = new StringBuilder();
        if (whereClause == null || whereClause.length < 1) {
            whereClauseStr.append("1");
        } else {
            for (i = 0; i < whereClause.length; ++i) {
                whereClauseStr.append(whereClause[i]);
                whereClauseStr.append(" = ?");
                if (i >= whereClause.length - 1) continue;
                whereClauseStr.append(SQL_AND);
            }
        }
        this.logDeleteQuery(whereValues, dbName, whereClauseStr);
        String[] fixedWhereValues = new String[whereValues.length];
        for (i = 0; i < whereValues.length; ++i) {
            fixedWhereValues[i] = whereValues[i].toString();
        }
        return this.getDatabase().delete(dbName, whereClauseStr.toString(), fixedWhereValues);
    }

    private void logDeleteQuery(Object[] whereValues, String dbName, StringBuilder whereClauseStr) {
        String sql = JSONStoreUtil.formatString(SQL_DELETE, dbName, whereClauseStr.toString());
        this.logger.trace("executing delete on database \"" + dbName + "\":");
        this.logger.trace("   " + sql);
        this.logger.trace("   args:");
        for (int i = 0; i < whereValues.length; ++i) {
            this.logger.trace("      " + whereValues[i]);
        }
    }

    public int deleteIfRequired(JSONObject obj, boolean isErase, boolean exact) throws JSONException {
        boolean doErase = isErase;
        boolean theEasyWay = true;
        int result = 0;
        int id = 0;
        String operation = null;
        try {
            id = obj.getInt("_id");
            operation = this.findOperationForObjectById(id);
        }
        catch (JSONException e) {
            theEasyWay = false;
        }
        if (theEasyWay) {
            if (operation != null && operation.equals("add")) {
                doErase = true;
            }
            result = doErase ? this.delete(new String[]{"_id"}, new Object[]{obj.getInt("_id")}) : this.update(new String[]{"_deleted", "_dirty", "_operation"}, new Object[]{1, new Date().getTime(), "remove"}, id);
        } else {
            int actionCount = 0;
            Cursor removeSet = null;
            removeSet = this.findUsingQueryObject(obj, new String[]{"_id", "_operation"}, new String[]{"_deleted = 0"}, null, null, exact);
            int setSize = removeSet.getCount();
            for (int i = 0; i < setSize; ++i) {
                JacksonSerializedJSONObject item = new JacksonSerializedJSONObject();
                removeSet.moveToNext();
                int intId = removeSet.getInt(0);
                String strOp = removeSet.getString(1);
                result = "add".compareToIgnoreCase(strOp) == 0 || isErase ? this.delete(new String[]{"_id"}, new Object[]{intId}) : this.update(new String[]{"_deleted", "_dirty", "_operation"}, new Object[]{1, new Date().getTime(), "remove"}, intId);
                actionCount += result;
            }
            result = actionCount;
            removeSet.close();
        }
        return result;
    }

    public int update(String[] columnNames, Object[] columnValues, Map<String, Object> whereClauses) {
        int i;
        String dbName = this.getSchema().getName();
        ContentValues values = new ContentValues();
        StringBuilder whereClause = null;
        String[] whereValues = null;
        if (whereClauses != null && whereClauses.size() > 0) {
            i = 0;
            Iterator<String> keys = whereClauses.keySet().iterator();
            whereClause = new StringBuilder();
            whereValues = new String[whereClauses.size()];
            while (keys.hasNext()) {
                String key = keys.next();
                whereClause.append(' ');
                whereClause.append(key);
                whereClause.append(" = ?");
                if (keys.hasNext()) {
                    whereClause.append(SQL_AND);
                }
                whereValues[i++] = whereClauses.get(key).toString();
            }
        }
        this.logUpdateQuery(columnNames, columnValues, dbName, whereClause, whereValues);
        for (i = 0; i < columnNames.length; ++i) {
            values.put(columnNames[i], columnValues[i].toString());
        }
        return this.getDatabase().update(dbName, values, whereClause == null ? null : whereClause.toString(), whereValues);
    }

    private void logUpdateQuery(String[] columnNames, Object[] columnValues, String dbName, StringBuilder whereClause, String[] whereValues) {
        StringBuilder columnsStr = new StringBuilder();
        for (int i = 0; i < columnNames.length; ++i) {
            columnsStr.append(columnNames[i]);
            columnsStr.append(" = ");
            columnsStr.append(columnValues[i]);
            if (i >= columnNames.length - 1) continue;
            columnsStr.append(", ");
        }
        String sql = JSONStoreUtil.formatString(SQL_UPDATE, dbName, columnsStr.toString(), whereClause == null ? "" : SQL_WHERE + whereClause.toString());
        this.logger.trace("executing update on database \"" + dbName + "\":");
        this.logger.trace("   sql: " + sql);
        this.logger.trace("   arguments:");
        for (String whereValue : whereValues) {
            this.logger.trace("      " + whereValue);
        }
    }

    public int update(String[] columnNames, Object[] columnValues, int id) throws JSONException {
        HashMap<String, Object> newWhereClauses = new HashMap<String, Object>();
        newWhereClauses.put("_id", id);
        return this.update(columnNames, columnValues, newWhereClauses);
    }

    public int update(Map<String, Object> columns, Map<String, Object> whereClauses) {
        String[] columnNames = new String[columns.size()];
        Object[] columnValues = new Object[columns.size()];
        int i = 0;
        for (String key : columns.keySet()) {
            columnNames[i] = "[" + JSONStoreUtil.getDatabaseSafeSearchFieldName(key) + "]";
            columnValues[i++] = columns.get(key);
        }
        return this.update(columnNames, columnValues, whereClauses);
    }

    public int update(JSONObject newObj, boolean markDirty) throws Throwable {
        long dirtyTime = markDirty ? new Date().getTime() : 0L;
        int id = newObj.getInt("_id");
        HashMap<String, Object> whereClauses = new HashMap<String, Object>();
        newObj = newObj.getJSONObject("json");
        Map<String, Object> mappedObj = this.getSchema().mapObject(newObj, null);
        mappedObj.put("_dirty", dirtyTime);
        mappedObj.put("_id", id);
        mappedObj.put("json", newObj.toString());
        String operation = this.findOperationForObjectById(id);
        if (operation == null || operation.equals("remove")) {
            throw new Throwable();
        }
        if (!operation.equals("add")) {
            mappedObj.put("_operation", "replace");
        }
        whereClauses.put("_id", id);
        return this.update(mappedObj, whereClauses);
    }
}

