/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import android.database.Cursor;
import com.worklight.common.Logger;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.sqlcipher.database.SQLiteDatabase;
import org.json.JSONException;
import org.json.JSONObject;

public class ReadableDatabase {
    private static final String JSONSTORE_DB = "jsonstore-db";
    private static final String SQL_AND = " AND ";
    private static final String SQL_EQ = " = ?";
    private static final String SQL_FIND = "SELECT {0} FROM {1};";
    private static final String SQL_FIND_BY_ID = "SELECT {0}, {1} FROM {2} WHERE {3} AND _deleted = 0";
    private static final String SQL_FIND_OP = "SELECT {0} FROM {1} WHERE {2} LIKE ?";
    private static final String SQL_FIND_WHERE = "SELECT {0} FROM {1} WHERE {2};";
    private static final String SQL_FIND_WHERE_WITH_LIMIT = "SELECT {0} FROM {1} WHERE {2} LIMIT {3};";
    private static final String SQL_FIND_WHERE_WITH_NEGATIVE_LIMIT = "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} DESC LIMIT {4};";
    private static final String SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET = "SELECT {0} FROM {1} WHERE {2} LIMIT {3} OFFSET {4};";
    private static final String SQL_FIND_WHERE_WITH_LIMIT_AND_ORDER = "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} LIMIT {4};";
    private static final String SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET_AND_ORDER = "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} LIMIT {4} OFFSET {5};";
    private static final String SQL_LIKE = " LIKE ?";
    private static final String SQL_OR = " OR ";
    private SQLiteDatabase database;
    protected Logger logger;
    private DatabaseSchema schema;

    protected ReadableDatabase(SQLiteDatabase database, DatabaseSchema schema) {
        this.database = database;
        this.logger = Logger.getInstance(JSONSTORE_DB);
        this.schema = schema;
    }

    protected SQLiteDatabase getDatabase() {
        return this.database;
    }

    protected DatabaseSchema getSchema() {
        return this.schema;
    }

    public Cursor findByIds(int ... ids) {
        StringBuilder idsStr = new StringBuilder();
        String[] selections = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idsStr.append("_id");
            idsStr.append(SQL_EQ);
            if (i < ids.length - 1) {
                idsStr.append(SQL_OR);
            }
            selections[i] = "" + ids[i];
        }
        return this.rawQuery(JSONStoreUtil.formatString(SQL_FIND_BY_ID, "_id", "json", this.schema.getName(), idsStr.toString()), selections);
    }

    protected String findOperationForObjectById(int id) {
        Cursor cursor = this.rawQuery(JSONStoreUtil.formatString(SQL_FIND_OP, "_operation", this.schema.getName(), "_id"), new String[]{"" + id});
        if (cursor.getCount() < 1) {
            cursor.close();
            return null;
        }
        cursor.moveToNext();
        String result = cursor.getString(0);
        cursor.close();
        return result;
    }

    public Cursor findUsingQueryObject(JSONObject queryObj, String[] fieldsToSelect, String[] extraWhereClauses, String limit, String offset, Boolean exact, String sortString) throws JSONException {
        StringBuilder fieldSelect = new StringBuilder();
        int length = queryObj.length();
        ArrayList<String> selectionArgs = new ArrayList<String>();
        String sql = null;
        StringBuilder whereClause = new StringBuilder();
        this.getFieldsToSelect(fieldsToSelect, fieldSelect);
        this.buildWhereClause(extraWhereClauses, whereClause);
        if (length == 0) {
            int limitInt = this.getLimit(limit);
            sql = this.buildFindAllQuery(limit, offset, sortString, fieldSelect, whereClause, limitInt);
        } else {
            sql = this.buildFindQuery(queryObj, limit, offset, exact, sortString, fieldSelect, selectionArgs, whereClause);
        }
        String[] str = new String[selectionArgs.size()];
        return this.rawQuery(sql, selectionArgs.toArray(str));
    }

    public Cursor findUsingQueryObject(JSONObject queryObj, String[] fieldsToSelect, String[] extraWhereClauses, String limit, String offset, Boolean exact) throws JSONException {
        return this.findUsingQueryObject(queryObj, fieldsToSelect, extraWhereClauses, limit, offset, exact, null);
    }

    private String buildFindQuery(JSONObject queryObj, String limit, String offset, Boolean exact, String sortString, StringBuilder fieldSelect, ArrayList<String> selectionArgs, StringBuilder whereClause) throws JSONException {
        String sql;
        StringBuilder clause = new StringBuilder();
        Iterator keys = queryObj.keys();
        int limitInt = this.getLimit(limit);
        this.handleExact(queryObj, exact, selectionArgs, clause, keys);
        if (whereClause.length() > 0) {
            clause.append(SQL_AND);
            clause.append((CharSequence)whereClause);
        }
        if (limit == null) {
            sql = JSONStoreUtil.formatString(SQL_FIND_WHERE, fieldSelect.toString(), this.schema.getName(), clause.toString());
            if (this.hasSortParameter(sortString)) {
                sql = sql.substring(0, sql.length() - 1) + " ORDER BY " + sortString + ";";
            }
        } else if (offset != null) {
            sql = this.hasSortParameter(sortString) ? JSONStoreUtil.formatString(SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET_AND_ORDER, fieldSelect.toString(), this.schema.getName(), clause.toString(), sortString, limit, offset) : JSONStoreUtil.formatString(SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET, fieldSelect.toString(), this.schema.getName(), clause.toString(), limit, offset);
        } else if (limitInt < 0) {
            limitInt = Math.abs(limitInt);
            limit = String.valueOf(limitInt);
            sql = JSONStoreUtil.formatString(SQL_FIND_WHERE_WITH_NEGATIVE_LIMIT, fieldSelect.toString(), this.schema.getName(), clause.toString(), "_id", limit);
        } else {
            sql = this.hasSortParameter(sortString) ? JSONStoreUtil.formatString(SQL_FIND_WHERE_WITH_LIMIT_AND_ORDER, fieldSelect.toString(), this.schema.getName(), clause.toString(), sortString, limit) : JSONStoreUtil.formatString(SQL_FIND_WHERE_WITH_LIMIT, fieldSelect.toString(), this.schema.getName(), clause.toString(), limit);
        }
        return sql;
    }

    private void handleExact(JSONObject queryObj, Boolean exact, ArrayList<String> selectionArgs, StringBuilder clause, Iterator<?> keys) throws JSONException {
        if (!exact.booleanValue()) {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = queryObj.get(key);
                clause.append("[" + JSONStoreUtil.getDatabaseSafeSearchFieldName(key) + "]");
                clause.append(SQL_LIKE);
                if (keys.hasNext()) {
                    clause.append(SQL_AND);
                }
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? 1 : 0;
                }
                selectionArgs.add("%" + value + "%");
            }
        } else {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = queryObj.get(key);
                String safeKey = "[" + JSONStoreUtil.getDatabaseSafeSearchFieldName(key) + "]";
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? 1 : 0;
                }
                clause.append(" ( ");
                clause.append(safeKey);
                clause.append(SQL_EQ);
                clause.append(SQL_OR);
                clause.append(safeKey);
                clause.append(SQL_LIKE);
                clause.append(SQL_OR);
                clause.append(safeKey);
                clause.append(SQL_LIKE);
                clause.append(SQL_OR);
                clause.append(safeKey);
                clause.append(SQL_LIKE);
                selectionArgs.add("" + value);
                selectionArgs.add("%-@-" + value);
                selectionArgs.add("%-@-" + value + "-@-%");
                selectionArgs.add(value + "-@-%");
                clause.append(" ) ");
                if (!keys.hasNext()) continue;
                clause.append(SQL_AND);
            }
        }
    }

    private String buildFindAllQuery(String limit, String offset, String sortString, StringBuilder fieldSelect, StringBuilder whereClause, int limitInt) {
        String sql;
        if (whereClause.length() > 0) {
            String whereTemplate = "";
            if (limit == null) {
                whereTemplate = SQL_FIND_WHERE;
                sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString());
                if (this.hasSortParameter(sortString)) {
                    sql = sql.substring(0, sql.length() - 1) + " ORDER BY " + sortString + ";";
                }
            } else if (offset != null) {
                if (this.hasSortParameter(sortString)) {
                    whereTemplate = SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET_AND_ORDER;
                    sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString(), sortString, limit, offset);
                } else {
                    whereTemplate = SQL_FIND_WHERE_WITH_LIMIT_AND_OFFSET;
                    sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString(), limit, offset);
                }
            } else if (limitInt < 0) {
                limitInt = Math.abs(limitInt);
                limit = String.valueOf(limitInt);
                whereTemplate = SQL_FIND_WHERE_WITH_NEGATIVE_LIMIT;
                sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString(), "_id", limit);
            } else if (this.hasSortParameter(sortString)) {
                whereTemplate = SQL_FIND_WHERE_WITH_LIMIT_AND_ORDER;
                sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString(), sortString, limit);
            } else {
                whereTemplate = SQL_FIND_WHERE_WITH_LIMIT;
                sql = JSONStoreUtil.formatString(whereTemplate, fieldSelect.toString(), this.schema.getName(), whereClause.toString(), limit);
            }
        } else {
            sql = JSONStoreUtil.formatString(SQL_FIND, fieldSelect.toString(), this.schema.getName());
            if (this.hasSortParameter(sortString)) {
                sql = sql.substring(0, sql.length() - 1) + " ORDER BY " + sortString + ";";
            }
        }
        return sql;
    }

    private boolean hasSortParameter(String sortString) {
        return sortString != null && sortString.trim().length() > 0;
    }

    private int getLimit(String limit) {
        int limitInt;
        try {
            limitInt = Integer.parseInt(limit);
        }
        catch (NumberFormatException e) {
            limitInt = 0;
        }
        return limitInt;
    }

    private void getFieldsToSelect(String[] fieldsToSelect, StringBuilder fieldSelect) {
        if (fieldsToSelect == null || fieldsToSelect.length == 0) {
            fieldSelect.append('*');
        } else {
            for (int i = 0; i < fieldsToSelect.length; ++i) {
                fieldSelect.append(fieldsToSelect[i]);
                if (i >= fieldsToSelect.length - 1) continue;
                fieldSelect.append(", ");
            }
        }
    }

    private void buildWhereClause(String[] extraWhereClauses, StringBuilder whereClause) {
        if (extraWhereClauses != null && extraWhereClauses.length > 0) {
            for (int i = 0; i < extraWhereClauses.length; ++i) {
                whereClause.append(extraWhereClauses[i]);
                if (i >= extraWhereClauses.length - 1) continue;
                whereClause.append(SQL_AND);
            }
        }
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        this.logger.trace("executing query on database \"" + this.schema.getName() + "\":");
        this.logger.trace("   " + sql);
        if (selectionArgs != null) {
            this.logger.trace("arguments:");
            for (String selectionArg : selectionArgs) {
                this.logger.trace("   " + selectionArg);
            }
        }
        return this.database.rawQuery(sql, selectionArgs);
    }
}

