/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

public enum QueryPartOperation {
    EXACT_EQUALS("equal", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    EXACT_NOT_EQUALS("notEqual", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_EQUALS("like", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_NOT_EQUALS("notLike", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_LEFT_EQUALS("leftLike", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_NOT_LEFT_EQUALS("notLeftLike", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_RIGHT_EQUALS("rightLike", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    FUZZY_NOT_RIGHT_EQUALS("notRightLike", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    LESS_THAN("lessThan", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    LESS_THAN_OR_EQUALS("lessOrEqualThan", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    GREATER_THAN("greaterThan", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    GREATER_THAN_OR_EQUALS("greaterOrEqualThan", QueryPartOperationRestriction.PRIMITIVE_ONLY),
    BETWEEN("between", QueryPartOperationRestriction.RANGE_ONLY),
    NOT_BETWEEN("notBetween", QueryPartOperationRestriction.RANGE_ONLY),
    IN("inside", QueryPartOperationRestriction.ARRAY_ONLY),
    NOT_IN("notInside", QueryPartOperationRestriction.ARRAY_ONLY);

    private String queryString;
    private QueryPartOperationRestriction restriction;

    private QueryPartOperation(String name, QueryPartOperationRestriction restriction) {
        this.queryString = name;
        this.restriction = restriction;
    }

    public boolean queryStringMatches(String query_key) {
        if (query_key == null) {
            return false;
        }
        return query_key.equalsIgnoreCase(this.queryString) || query_key.equalsIgnoreCase("$" + this.queryString);
    }

    public QueryPartOperationRestriction getRestriction() {
        return this.restriction;
    }

    public static enum QueryPartOperationRestriction {
        PRIMITIVE_ONLY,
        RANGE_ONLY,
        ARRAY_ONLY;

    }
}

