/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import com.worklight.jsonstore.api.JSONStoreCollection;
import com.worklight.jsonstore.api.JSONStoreQueryParts;
import com.worklight.jsonstore.database.QueryBuilder;
import com.worklight.jsonstore.database.SortDirection;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryBuilderSelect
extends QueryBuilder {
    private Integer limit;
    private Integer offset;
    private Map<String, Boolean> selectStatements;
    private LinkedHashMap<String, SortDirection> sort;

    public QueryBuilderSelect(JSONStoreCollection collection, JSONStoreQueryParts content) {
        super(collection, content);
        this.generalInit();
    }

    private void generalInit() {
        this.limit = null;
        this.offset = null;
        this.selectStatements = new LinkedHashMap<String, Boolean>();
        this.sort = new LinkedHashMap();
    }

    public void setLimit(Integer limit) throws IllegalArgumentException {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setOffset(Integer offset) throws IllegalArgumentException {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void addSelectStatement(String statement, Boolean is_special) throws IllegalArgumentException {
        if (statement == null || statement.isEmpty()) {
            throw new IllegalArgumentException("statement parameter is null or empty");
        }
        if (is_special == null) {
            throw new IllegalArgumentException("is_special parameter is null");
        }
        this.selectStatements.put(statement, is_special);
    }

    protected Map<String, Boolean> getSelectStatements() {
        return this.selectStatements;
    }

    protected void buildSelectStatement(StringBuilder query_string, List<String> selection_args) throws IllegalArgumentException {
        if (query_string == null) {
            throw new IllegalArgumentException("query_string parameter is null");
        }
        if (selection_args == null) {
            throw new IllegalArgumentException("selection_args parameter is null");
        }
        if (this.selectStatements.isEmpty()) {
            this.selectStatements.put("*", true);
        }
        Iterator<String> statementIterator = this.selectStatements.keySet().iterator();
        query_string.append(" ");
        while (statementIterator.hasNext()) {
            String statement = statementIterator.next();
            Boolean isSpecial = this.selectStatements.get(statement);
            String safeStatement = statement;
            if (!isSpecial.booleanValue()) {
                safeStatement = "[" + JSONStoreUtil.getDatabaseSafeSearchFieldName(safeStatement) + "]";
            }
            query_string.append(safeStatement);
            if (!statementIterator.hasNext()) continue;
            query_string.append(", ");
        }
        query_string.append(" ");
    }

    protected void buildModifiers(StringBuilder queryString, List<String> selectionArgs) throws IllegalArgumentException {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString parameter is null");
        }
        if (selectionArgs == null) {
            throw new IllegalArgumentException("selectionArgs parameter is null");
        }
        Integer limit = this.getLimit();
        Integer offset = this.getOffset();
        if (this.sort == null) {
            this.sort = new LinkedHashMap();
        }
        if (limit != null && limit < 0) {
            this.sort.clear();
            this.sort.put("_id", SortDirection.DESCENDING);
        }
        if (this.sort.size() > 0) {
            Iterator<Map.Entry<String, SortDirection>> sortOrderIterator = this.sort.entrySet().iterator();
            StringBuilder sortBuilder = new StringBuilder();
            while (sortOrderIterator.hasNext()) {
                Map.Entry<String, SortDirection> sortEntry = sortOrderIterator.next();
                String sortKey = sortEntry.getKey();
                SortDirection sortDir = sortEntry.getValue();
                if (sortDir == SortDirection.ASCENDING) {
                    sortBuilder.append(",");
                    sortBuilder.append(" [" + JSONStoreUtil.getDatabaseSafeSearchFieldName(sortKey) + "] ASC ");
                    continue;
                }
                if (sortDir != SortDirection.DESCENDING) continue;
                sortBuilder.append(",");
                sortBuilder.append(" [" + JSONStoreUtil.getDatabaseSafeSearchFieldName(sortKey) + "] DESC ");
            }
            if (sortBuilder.length() > 1) {
                sortBuilder.deleteCharAt(0);
                queryString.append("  ORDER BY  ");
                queryString.append((CharSequence)sortBuilder);
            }
        }
        if (limit != null) {
            int limitAbs = limit;
            if (limitAbs < 0) {
                limitAbs = -limitAbs;
            }
            queryString.append("  LIMIT  " + limitAbs + " ");
        }
        if (offset != null && limit != null) {
            queryString.append("  OFFSET  " + offset + " ");
        }
    }

    @Override
    public void convertToQueryString(StringBuilder query_string, List<String> selection_args) throws IllegalArgumentException {
        query_string.append(" SELECT ");
        this.buildSelectStatement(query_string, selection_args);
        query_string.append(" FROM ");
        this.buildFromClause(query_string, selection_args);
        query_string.append(" WHERE ");
        this.buildWhereClause(query_string, selection_args);
        this.buildModifiers(query_string, selection_args);
    }

    public void clearAllModifiers() {
        this.limit = null;
        this.offset = null;
        if (this.sort != null) {
            this.sort.clear();
        }
    }

    public void clearAllSelectStatements() {
        this.selectStatements.clear();
    }

    public LinkedHashMap<String, SortDirection> getSort() {
        return this.sort;
    }

    public void setSort(LinkedHashMap<String, SortDirection> sort) {
        this.sort = sort;
    }
}

