/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import com.worklight.jsonstore.api.JSONStoreCollection;
import com.worklight.jsonstore.api.JSONStoreQueryPart;
import com.worklight.jsonstore.api.JSONStoreQueryPartItem;
import com.worklight.jsonstore.api.JSONStoreQueryParts;
import com.worklight.jsonstore.database.QueryPartOperation;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.Iterator;
import java.util.List;

public abstract class QueryBuilder {
    private JSONStoreQueryParts queryContent;
    private JSONStoreCollection collectionToSearch;
    private DeletedInclusion deletedInclusion;

    public QueryBuilder(JSONStoreCollection collection, JSONStoreQueryParts content) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("collection parameter is null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content parameter cannot be null");
        }
        this.collectionToSearch = collection;
        this.deletedInclusion = DeletedInclusion.NON_DELETED_ONLY;
        this.queryContent = content;
    }

    public void setSearchDeletedOnly() {
        this.deletedInclusion = DeletedInclusion.DELETED_ONLY;
    }

    public void setSearchStandard() {
        this.deletedInclusion = DeletedInclusion.NON_DELETED_ONLY;
    }

    public void setSearchIncludeDeleted() {
        this.deletedInclusion = DeletedInclusion.DELETED_AND_NOT_DELETED;
    }

    private Object convertObjectIfBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == true ? 1 : 0;
        }
        return o;
    }

    protected void buildFromClause(StringBuilder query_string, List<String> selection_args) throws IllegalArgumentException {
        query_string.append(" " + this.collectionToSearch.getName() + " ");
    }

    private void handleExactEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.EXACT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" = ?");
        builder.append(" OR ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" OR ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" OR ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" ) ");
        selection_args.add("" + value);
        selection_args.add("%-@-" + value);
        selection_args.add("%-@-" + value + "-@-%");
        selection_args.add(value + "-@-%");
    }

    private void handleExactNotEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.EXACT_NOT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" != ?");
        builder.append(" AND ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" AND ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" AND ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" ) ");
        selection_args.add("" + value);
        selection_args.add("%-@-" + value);
        selection_args.add("%-@-" + value + "-@-%");
        selection_args.add(value + "-@-%");
    }

    private void handleFuzzyEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" LIKE ?");
        selection_args.add("%" + value + "%");
    }

    private void handleFuzzyNotEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_NOT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        selection_args.add("%" + value + "%");
    }

    private void handleFuzzyLeftEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_LEFT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" OR ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" ) ");
        selection_args.add("%" + value);
        selection_args.add("%" + value + "-@-%");
    }

    private void handleFuzzyNotLeftEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_NOT_LEFT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" AND ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" ) ");
        selection_args.add("%" + value);
        selection_args.add("%" + value + "-@-%");
    }

    private void handleFuzzyRightEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_RIGHT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" OR ");
        builder.append(safe_key);
        builder.append(" LIKE ?");
        builder.append(" ) ");
        selection_args.add(value + "%");
        selection_args.add("%-@-" + value + "%");
    }

    private void handleFuzzyNotRightEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.FUZZY_NOT_RIGHT_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(" ( ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" AND ");
        builder.append(safe_key);
        builder.append(" NOT LIKE ?");
        builder.append(" ) ");
        selection_args.add(value + "%");
        selection_args.add("%-@-" + value + "%");
    }

    private void handleBetweenCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.BETWEEN) {
            return;
        }
        List rangeList = (List)value;
        Object firstVal = this.convertObjectIfBoolean(rangeList.get(0));
        Object secondVal = this.convertObjectIfBoolean(rangeList.get(1));
        builder.append(safe_key);
        builder.append(" BETWEEN ? AND ? ");
        selection_args.add(firstVal.toString());
        selection_args.add(secondVal.toString());
    }

    private void handleNotBetweenCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.NOT_BETWEEN) {
            return;
        }
        List rangeList = (List)value;
        Object firstVal = this.convertObjectIfBoolean(rangeList.get(0));
        Object secondVal = this.convertObjectIfBoolean(rangeList.get(1));
        builder.append(safe_key);
        builder.append(" NOT BETWEEN ? AND ? ");
        selection_args.add(firstVal.toString());
        selection_args.add(secondVal.toString());
    }

    private void handleInCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.IN) {
            return;
        }
        List inObjectsArray = (List)value;
        builder.append(safe_key);
        builder.append(" IN ");
        builder.append(" ( ");
        Iterator elementIterator = inObjectsArray.iterator();
        while (elementIterator.hasNext()) {
            builder.append(" ?");
            Object currentItem = this.convertObjectIfBoolean(elementIterator.next());
            selection_args.add(currentItem.toString());
            if (!elementIterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(" )");
    }

    private void handleNotInCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.NOT_IN) {
            return;
        }
        List inObjectsArray = (List)value;
        builder.append(safe_key);
        builder.append(" NOT IN ");
        builder.append(" ( ");
        Iterator elementIterator = inObjectsArray.iterator();
        while (elementIterator.hasNext()) {
            builder.append(" ?");
            Object currentItem = this.convertObjectIfBoolean(elementIterator.next());
            selection_args.add(currentItem.toString());
            if (!elementIterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(" )");
    }

    private void handleGreaterThanCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.GREATER_THAN) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" > ?");
        selection_args.add("" + value);
    }

    private void handleGreaterThanEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.GREATER_THAN_OR_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" >= ?");
        selection_args.add("" + value);
    }

    private void handleLessThanCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.LESS_THAN) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" < ?");
        selection_args.add("" + value);
    }

    private void handleLessThanEqualsCase(StringBuilder builder, List<String> selection_args, QueryPartOperation operation, String safe_key, Object value) {
        if (operation != QueryPartOperation.LESS_THAN_OR_EQUALS) {
            return;
        }
        value = this.convertObjectIfBoolean(value);
        builder.append(safe_key);
        builder.append(" <= ?");
        selection_args.add("" + value);
    }

    protected void buildWhereClause(StringBuilder query_string, List<String> selection_args) throws IllegalArgumentException {
        if (query_string == null) {
            throw new IllegalArgumentException("query_string parameter is null");
        }
        if (selection_args == null) {
            throw new IllegalArgumentException("selection_args parameter is null");
        }
        StringBuilder whereBlock = new StringBuilder();
        StringBuilder whereBlockClause = new StringBuilder();
        List<JSONStoreQueryPart> queryContentParts = this.queryContent.getAllQueryParts();
        Iterator<JSONStoreQueryPart> queryContentPartIterator = queryContentParts.iterator();
        while (queryContentPartIterator.hasNext()) {
            JSONStoreQueryPart queryContentPart = queryContentPartIterator.next();
            List<JSONStoreQueryPartItem> queryBlockItems = queryContentPart.getQueryBlockItems();
            Iterator<JSONStoreQueryPartItem> queryBlockIterator = queryBlockItems.iterator();
            while (queryBlockIterator.hasNext()) {
                JSONStoreQueryPartItem item = queryBlockIterator.next();
                QueryPartOperation operation = item.getOperation();
                String safeKey = item.isKeySpecial() ? item.getKey() : "[" + JSONStoreUtil.getDatabaseSafeSearchFieldName(item.getKey()) + "]";
                Object value = item.getValue();
                StringBuilder currentClause = new StringBuilder();
                this.handleExactEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleExactNotEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyNotEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyLeftEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyNotLeftEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyRightEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleFuzzyNotRightEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleBetweenCase(currentClause, selection_args, operation, safeKey, value);
                this.handleNotBetweenCase(currentClause, selection_args, operation, safeKey, value);
                this.handleInCase(currentClause, selection_args, operation, safeKey, value);
                this.handleNotInCase(currentClause, selection_args, operation, safeKey, value);
                this.handleGreaterThanCase(currentClause, selection_args, operation, safeKey, value);
                this.handleGreaterThanEqualsCase(currentClause, selection_args, operation, safeKey, value);
                this.handleLessThanCase(currentClause, selection_args, operation, safeKey, value);
                this.handleLessThanEqualsCase(currentClause, selection_args, operation, safeKey, value);
                if (currentClause.length() > 0) {
                    whereBlockClause.append(" ( ");
                    whereBlockClause.append((CharSequence)currentClause);
                    whereBlockClause.append(" ) ");
                }
                if (!queryBlockIterator.hasNext()) continue;
                whereBlockClause.append(" AND ");
            }
            if (!queryContentPartIterator.hasNext()) continue;
            whereBlockClause.append(" OR ");
        }
        if (whereBlockClause.length() > 0) {
            whereBlock.append("(");
            whereBlock.append((CharSequence)whereBlockClause);
            whereBlock.append(")");
        }
        if (this.deletedInclusion == DeletedInclusion.NON_DELETED_ONLY) {
            if (whereBlock.length() > 0) {
                whereBlock.append(" AND ");
            }
            whereBlock.append(" _deleted = 0 ");
        } else if (this.deletedInclusion == DeletedInclusion.DELETED_ONLY) {
            if (whereBlock.length() > 0) {
                whereBlock.append(" AND ");
            }
            whereBlock.append("_deleted = 1");
        }
        if (whereBlock.length() == 0) {
            whereBlock.append(1);
        }
        query_string.append((CharSequence)whereBlock);
    }

    public abstract void convertToQueryString(StringBuilder var1, List<String> var2) throws IllegalArgumentException;

    public static enum DeletedInclusion {
        DELETED_AND_NOT_DELETED,
        NON_DELETED_ONLY,
        DELETED_ONLY;

    }
}

