/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import android.content.Context;
import com.worklight.jsonstore.database.DatabaseAccessor;
import com.worklight.jsonstore.database.DatabaseManager;
import com.worklight.jsonstore.database.SearchFieldType;
import com.worklight.jsonstore.jackson.JacksonSerializedJSONArray;
import com.worklight.jsonstore.jackson.JacksonSerializedJSONObject;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DatabaseSchema {
    private String name;
    private TreeMap<String, SearchFieldType> nodes;
    private TreeMap<String, SearchFieldType> safeNodes;
    private TreeMap<String, SearchFieldType> internalNodes;

    public DatabaseSchema(String name) {
        this.name = name;
        this.nodes = new TreeMap();
        this.safeNodes = new TreeMap();
        this.internalNodes = new TreeMap();
        try {
            this.internalNodes.put("_deleted", SearchFieldType.BOOLEAN);
            this.internalNodes.put("_dirty", SearchFieldType.NUMBER);
            this.internalNodes.put("_id", SearchFieldType.INTEGER);
            this.internalNodes.put("json", SearchFieldType.STRING);
            this.internalNodes.put("_operation", SearchFieldType.STRING);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public DatabaseSchema(String name, Map<String, SearchFieldType> search_fields) throws Throwable {
        this(name);
        for (String key : search_fields.keySet()) {
            this.addSearchField(key, search_fields.get(key));
        }
    }

    public String getName() {
        return this.name;
    }

    public Iterator<String> getSearchFieldIterator() {
        return this.nodes.keySet().iterator();
    }

    public SearchFieldType getSearchFieldType(String name) {
        return this.nodes.get(name);
    }

    private void addSearchField(String name, SearchFieldType type) throws Throwable {
        if (name == null) {
            throw new Throwable("invalid search field (null) specified");
        }
        if ((name = name.trim()).equals("") || name.indexOf("..") != -1 || name.startsWith(".") || name.endsWith(".")) {
            throw new Throwable("invalid search field (\"" + name + "\") " + "specified");
        }
        String nameFixed = name.toLowerCase();
        if (this.nodes.containsKey(nameFixed) || this.internalNodes.containsKey(nameFixed)) {
            throw new Throwable("search field with name \"" + name + "\" " + " is used internally and cannot be reused");
        }
        this.nodes.put(nameFixed, type);
        this.safeNodes.put(JSONStoreUtil.getDatabaseSafeSearchFieldName(nameFixed), type);
    }

    private String encodeJSONArrayAsString(JSONArray array, String path) throws JSONException {
        int length = array.length();
        Object result = null;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result = array.get(i);
            if (result instanceof JSONObject) {
                result = this.locateChildInObject((JSONObject)result, path);
            }
            if (result == null) continue;
            str.append(result.toString());
            if (i >= length - 1) continue;
            str.append("-@-");
        }
        return str.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatabaseSchema)) {
            return false;
        }
        DatabaseSchema other = (DatabaseSchema)o;
        return other.nodes.equals(this.nodes);
    }

    public boolean equals(TreeMap<String, String> schema_compare) {
        if (schema_compare.size() != this.nodes.size() + this.internalNodes.size()) {
            return false;
        }
        for (String key : schema_compare.keySet()) {
            String safeKey = JSONStoreUtil.getDatabaseSafeSearchFieldName(key);
            SearchFieldType type = null;
            if (this.safeNodes.containsKey(safeKey)) {
                type = this.nodes.get(safeKey);
                if (null == type) {
                    type = this.safeNodes.get(safeKey);
                }
            } else {
                type = this.internalNodes.get(safeKey);
            }
            if (type != null && type.getMappedType().equals(schema_compare.get(key))) continue;
            return false;
        }
        return true;
    }

    private Object getValueFromObjectCaseInsensitive(JSONObject obj, String path) {
        JSONArray keys = obj.names();
        if (keys == null) {
            return null;
        }
        int length = keys.length();
        for (int i = 0; i < length; ++i) {
            String key = keys.optString(i);
            if (key == null || !key.toLowerCase().equals(path)) continue;
            return obj.opt(key);
        }
        return null;
    }

    private Object locateChildInObject(JSONObject obj, String path) {
        Object childObj = null;
        int index = path.indexOf(46);
        if (index == -1) {
            childObj = obj.opt(path);
            if (childObj == null) {
                return this.getValueFromObjectCaseInsensitive(obj, path);
            }
            if (childObj instanceof JSONArray) {
                try {
                    return this.encodeJSONArrayAsString((JSONArray)childObj, path);
                }
                catch (JSONException e) {
                    return null;
                }
            }
            return childObj;
        }
        try {
            childObj = obj.get(path.substring(0, index));
            if (childObj instanceof JSONObject) {
                return this.locateChildInObject((JSONObject)childObj, path.substring(index + 1));
            }
            if (childObj instanceof JSONArray) {
                return this.encodeJSONArrayAsString((JSONArray)childObj, path.substring(index + 1));
            }
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Map<String, Object> mapObject(JSONObject obj, JSONObject additional_search_fields) throws Throwable {
        Set<String> keys = this.nodes.keySet();
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        JSONObject normalizedObj = this.normalizeObject(obj);
        for (String key : keys) {
            Object value = this.locateChildInObject(normalizedObj, key);
            if (value != null) {
                result.put(key, value);
            }
            if (additional_search_fields == null || (value = this.locateChildInObject(additional_search_fields, key)) == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private void mergeIntoObject(JSONObject obj, String key, Object value) throws Throwable {
        int index = key.indexOf(46);
        if (index == -1) {
            this.mergeValues(obj, key, value);
            return;
        }
        String childKey = key.substring(0, index);
        JSONObject childObj = obj.optJSONObject(childKey);
        if (childObj == null) {
            childObj = new JacksonSerializedJSONObject();
            obj.put(childKey, (Object)childObj);
        }
        this.mergeIntoObject(childObj, key.substring(index + 1), value);
    }

    private void mergeValues(JSONObject obj, String key, Object value) throws Throwable {
        Object existingValue = obj.opt(key);
        if (existingValue == null) {
            obj.put(key, value);
            return;
        }
        if (existingValue instanceof JSONArray) {
            JSONArray array = (JSONArray)existingValue;
            int length = array.length();
            for (int i = 0; i < length; ++i) {
                if (array.opt(i) != value) continue;
                return;
            }
            array.put(value);
        } else {
            JacksonSerializedJSONArray array = new JacksonSerializedJSONArray();
            array.put(existingValue);
            array.put(value);
            obj.put(key, (Object)array);
        }
    }

    private JSONObject normalizeObject(JSONObject obj) throws Throwable {
        Iterator keys = obj.keys();
        JacksonSerializedJSONObject result = new JacksonSerializedJSONObject();
        if (keys == null) {
            return result;
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.mergeIntoObject(result, key, this.normalizeOrCopyObject(obj.get(key)));
        }
        return result;
    }

    private Object normalizeOrCopyObject(Object value) throws Throwable {
        if (value instanceof JSONObject) {
            return this.normalizeObject((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            JacksonSerializedJSONArray array = new JacksonSerializedJSONArray();
            JSONArray existingArray = (JSONArray)value;
            int length = existingArray.length();
            for (int i = 0; i < length; ++i) {
                array.put(this.normalizeOrCopyObject(existingArray.get(i)));
            }
            return array;
        }
        return value;
    }

    public boolean isSchemaMismatched(String dbName, DatabaseSchema requestedSchema, Context context) {
        DatabaseAccessor accessor = null;
        DatabaseManager dbManager = DatabaseManager.getInstance();
        try {
            accessor = dbManager.getDatabase(dbName);
        }
        catch (Exception e) {
            return dbManager.checkDatabaseAgainstSchema(context, dbName, requestedSchema);
        }
        return !accessor.getSchema().equals(requestedSchema);
    }
}

