/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import com.worklight.androidgap.jsonstore.security.SecurityManager;
import com.worklight.jsonstore.database.DatabaseAccessor;
import com.worklight.jsonstore.database.DatabaseAccessorImpl;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.util.JSONStoreLogger;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.io.File;
import java.util.HashMap;
import java.util.TreeMap;
import net.sqlcipher.database.SQLiteDatabase;

public class DatabaseManager {
    private static final String SQL_SCHEMA = "PRAGMA table_info({0})";
    private static boolean initialized = false;
    private static final DatabaseManager instance = new DatabaseManager();
    private static final JSONStoreLogger logger = JSONStoreUtil.getDatabaseLogger();
    private HashMap<String, DatabaseAccessor> accessors = new HashMap();
    private SQLiteDatabase database;
    private String databaseKey;
    private String dbPath;

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return instance;
    }

    public DatabaseAccessor getDatabase(String name) throws Exception {
        DatabaseAccessor accessor = this.accessors.get(name);
        if (accessor == null) {
            throw new Exception("could not retrieve unprovisioned database \"" + name + "\"");
        }
        return accessor;
    }

    public DatabaseAccessor getDatabase() throws Exception {
        if (this.accessors == null || this.accessors.size() == 0) {
            throw new Exception("could not retrieve unprovisioned database");
        }
        Object accessorObj = this.accessors.values().toArray()[0];
        DatabaseAccessor accessor = (DatabaseAccessor)accessorObj;
        return accessor;
    }

    public boolean isDatabaseOpen() {
        return this.database != null;
    }

    public void clearDatabaseKey() {
        this.databaseKey = null;
    }

    public void clearDbPath() {
        this.dbPath = null;
    }

    public void setDatabaseKey(Context context, String password, String username) throws Exception {
        this.databaseKey = SecurityManager.getInstance(context).getDPK(password, username);
    }

    public void setDbPath(String username) {
        this.dbPath = username + ".sqlite";
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public synchronized boolean checkDatabaseAgainstSchema(Context context, String modelName, DatabaseSchema schema) {
        this.openDatabaseIfNecessary(context);
        Cursor cursor = this.database.rawQuery(JSONStoreUtil.formatString(SQL_SCHEMA, modelName), null);
        if (cursor != null) {
            int numRows = cursor.getCount();
            TreeMap<String, String> tableSchema = null;
            if (numRows > 0) {
                tableSchema = new TreeMap<String, String>();
                for (int i = 0; i < numRows; ++i) {
                    cursor.moveToNext();
                    tableSchema.put(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("type")));
                }
            }
            cursor.close();
            if (tableSchema != null) {
                return !schema.equals(tableSchema);
            }
        }
        return false;
    }

    public synchronized void closeDatabase() {
        this.database.close();
        this.accessors.clear();
        this.database = null;
    }

    public synchronized int destroyDatabase(Context context) {
        String[] children;
        int rc = 0;
        File dbBaseDir = context.getDatabasePath("wljsonstore");
        if (dbBaseDir.exists() && dbBaseDir.isDirectory() && (children = dbBaseDir.list()) != null) {
            for (String c : children) {
                if (c == null || new File(dbBaseDir, c).delete()) continue;
                rc = -5;
            }
        }
        return rc;
    }

    public synchronized void destroyKeychain(Context context) {
        SecurityManager.getInstance(context).destroyKeychain();
    }

    public synchronized void destroyPreferences(Context context) {
        SharedPreferences sp = context.getSharedPreferences("JsonstorePrefs", 0);
        if (sp != null) {
            SharedPreferences.Editor editor = sp.edit();
            editor.clear();
            editor.commit();
        }
    }

    private void openDatabaseIfNecessary(Context context) {
        if (this.database == null) {
            if (!initialized) {
                SQLiteDatabase.loadLibs((Context)context);
                initialized = true;
            }
            if (this.databaseKey == null) {
                this.databaseKey = "";
            }
            File dbFile = new File(context.getDatabasePath("wljsonstore"), this.dbPath);
            this.database = SQLiteDatabase.openDatabase((String)dbFile.getAbsolutePath(), (String)this.databaseKey, null, (int)0x10000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean provisionDatabase(Context context, DatabaseSchema schema, boolean dropFirst) {
        DatabaseAccessorImpl accessor;
        boolean exists = false;
        String name = schema.getName();
        this.openDatabaseIfNecessary(context);
        DatabaseAccessorImpl databaseAccessorImpl = accessor = new DatabaseAccessorImpl(this.database, schema);
        synchronized (databaseAccessorImpl) {
            if (dropFirst) {
                accessor.dropTable();
            }
            if (accessor.getTableExists()) {
                exists = true;
            }
            logger.logDebug("provisioning database \"" + name + "\" (" + "already exists: " + exists + ")");
            if (!exists) {
                accessor.createTable();
            }
            this.accessors.put(name, accessor);
        }
        return exists;
    }
}

