/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.database;

import android.database.Cursor;
import com.worklight.jsonstore.database.DatabaseAccessor;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.database.ReadableDatabase;
import com.worklight.jsonstore.database.WritableDatabase;
import com.worklight.jsonstore.util.JSONStoreLogger;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.HashSet;
import java.util.Iterator;
import net.sqlcipher.database.SQLiteDatabase;

public class DatabaseAccessorImpl
implements DatabaseAccessor {
    private static final String SQL_CREATE_TABLE = "CREATE TABLE {0} ({1} INTEGER PRIMARY KEY AUTOINCREMENT, {2} {3} TEXT, {4} REAL DEFAULT 0, {5} INTEGER DEFAULT 0, {6} TEXT);";
    private static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS {0};";
    private static final String SQL_TABLE_EXISTS = "SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = \"{0}\";";
    private static final HashSet<String> ignoredSchemaNodes = new HashSet();
    private static final JSONStoreLogger logger = JSONStoreUtil.getDatabaseLogger();
    private SQLiteDatabase database;
    private ReadableDatabase readableDB;
    private DatabaseSchema schema;
    private WritableDatabase writableDB;

    protected DatabaseAccessorImpl(SQLiteDatabase database, DatabaseSchema schema) {
        this.database = database;
        this.readableDB = new ReadableDatabase(database, schema);
        this.schema = schema;
        this.writableDB = new WritableDatabase(database, schema);
    }

    @Override
    public SQLiteDatabase getRawDatabase() {
        return this.database;
    }

    @Override
    public ReadableDatabase getReadableDatabase() {
        return this.readableDB;
    }

    @Override
    public DatabaseSchema getSchema() {
        return this.schema;
    }

    @Override
    public boolean getTableExists() {
        boolean result = false;
        String sql = JSONStoreUtil.formatString(SQL_TABLE_EXISTS, this.schema.getName());
        Cursor cursor = this.readableDB.rawQuery(sql, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                result = true;
            }
            cursor.close();
        }
        return result;
    }

    @Override
    public WritableDatabase getWritableDatabase() {
        return this.writableDB;
    }

    @Override
    public void createTable() {
        String name = this.schema.getName();
        logger.logTrace("creating database \"" + name + "\"");
        this.execSQL(SQL_CREATE_TABLE, name, "_id", this.formatSchemaColumns(), "json", "_dirty", "_deleted", "_operation");
    }

    @Override
    public void dropTable() {
        String name = this.schema.getName();
        logger.logTrace("[!!!] dropping database \"" + name + "\"");
        this.execSQL(SQL_DROP_TABLE, name);
    }

    private void execSQL(String sql, Object ... args) {
        String formattedSQL = JSONStoreUtil.formatString(sql, args);
        logger.logTrace("executing SQL on database \"" + this.schema.getName() + "\":");
        logger.logTrace("   " + formattedSQL);
        this.writableDB.getDatabase().execSQL(formattedSQL);
    }

    private String formatSchemaColumns() {
        StringBuilder result = new StringBuilder();
        Iterator<String> schemaNodeNames = this.schema.getSearchFieldIterator();
        HashSet<String> schemaNodes = new HashSet<String>();
        while (schemaNodeNames.hasNext()) {
            String schemaNodeName = schemaNodeNames.next();
            if (ignoredSchemaNodes.contains(schemaNodeName)) continue;
            schemaNodes.add(schemaNodeName);
        }
        for (String schemaNode : schemaNodes) {
            result.append("'" + JSONStoreUtil.getDatabaseSafeSearchFieldName(schemaNode) + "'");
            result.append(' ');
            result.append(this.schema.getSearchFieldType(schemaNode).getMappedType());
            result.append(", ");
        }
        return result.toString();
    }

    static {
        ignoredSchemaNodes.add("_deleted");
        ignoredSchemaNodes.add("_dirty");
        ignoredSchemaNodes.add("_id");
        ignoredSchemaNodes.add("json");
        ignoredSchemaNodes.add("_operation");
    }
}

