/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import android.content.Context;
import android.content.SharedPreferences;
import com.worklight.androidgap.jsonstore.security.SecurityManager;
import com.worklight.jsonstore.api.JSONStoreCollection;
import com.worklight.jsonstore.api.JSONStoreFileInfo;
import com.worklight.jsonstore.api.JSONStoreInitOptions;
import com.worklight.jsonstore.database.DatabaseAccessor;
import com.worklight.jsonstore.database.DatabaseManager;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.exceptions.JSONStoreChangePasswordException;
import com.worklight.jsonstore.exceptions.JSONStoreCloseAllException;
import com.worklight.jsonstore.exceptions.JSONStoreDatabaseClosedException;
import com.worklight.jsonstore.exceptions.JSONStoreDestroyFailureException;
import com.worklight.jsonstore.exceptions.JSONStoreFileAccessException;
import com.worklight.jsonstore.exceptions.JSONStoreInvalidPasswordException;
import com.worklight.jsonstore.exceptions.JSONStoreInvalidSchemaException;
import com.worklight.jsonstore.exceptions.JSONStoreMigrationException;
import com.worklight.jsonstore.exceptions.JSONStoreNoTransactionInProgressException;
import com.worklight.jsonstore.exceptions.JSONStoreSchemaMismatchException;
import com.worklight.jsonstore.exceptions.JSONStoreTransactionDuringInitException;
import com.worklight.jsonstore.exceptions.JSONStoreTransactionFailureException;
import com.worklight.jsonstore.exceptions.JSONStoreTransactionInProgressException;
import com.worklight.jsonstore.util.JSONStoreLogger;
import com.worklight.jsonstore.util.JSONStoreUtil;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WLJSONStore {
    private static final String LIBCRYPTO_FILE_NAME = "libcrypto.so.1.0.0";
    private static final int NUM_BYTES_FOR_SALT = 32;
    private Context context = null;
    private JSONStoreLogger logger = JSONStoreUtil.getCoreLogger();
    private static boolean transactionInProgress = false;
    private String username;
    private static WLJSONStore instance;
    private Map<String, JSONStoreCollection> collectionMap = new HashMap<String, JSONStoreCollection>();

    private WLJSONStore(Context context) {
        this.context = context;
        WLUtils.loadLib(context, LIBCRYPTO_FILE_NAME);
    }

    private Context getContext() {
        return this.context;
    }

    String getUsername() {
        return this.username;
    }

    private void checkVersionMigration(Context context) throws JSONStoreFileAccessException, JSONStoreMigrationException {
        JSONStoreLogger.logFileInfo(this.getFileInfo());
        SharedPreferences sp = context.getSharedPreferences("JsonstorePrefs", 0);
        String ver = sp.getString("JsonstoreVer", null);
        if (ver == null) {
            boolean mkdirWorked;
            this.logger.logTrace("Performing migration to JSONStore 2.0");
            File dbBaseDir = context.getDatabasePath("wljsonstore");
            if (!dbBaseDir.exists() && !(mkdirWorked = dbBaseDir.mkdirs())) {
                String message = "Unable to create jsonstore directory.";
                JSONStoreFileAccessException e = new JSONStoreFileAccessException(message);
                this.logger.logTrace(message);
                throw e;
            }
            File dbFile = context.getDatabasePath("com.ibm.worklight.database");
            if (dbFile.exists()) {
                boolean moveWorked = dbFile.renameTo(new File(dbBaseDir, "jsonstore.sqlite"));
                if (moveWorked) {
                    this.logger.logTrace("Migration to JSONStore 2.0 successful.");
                } else {
                    String message = "Unable to migrate existing JSONStore database to version 2.0";
                    JSONStoreMigrationException e = new JSONStoreMigrationException(message);
                    this.logger.logTrace(message);
                    throw e;
                }
            }
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("JsonstoreVer", "2.0");
            editor.commit();
        }
    }

    private boolean provisionDatabase(JSONStoreCollection collection, DatabaseSchema schema, String username, String password, boolean dropFirst, String secureRandom) throws JSONStoreFileAccessException, JSONStoreMigrationException, JSONStoreCloseAllException, JSONStoreInvalidPasswordException, JSONStoreSchemaMismatchException {
        this.checkVersionMigration(this.getContext());
        DatabaseManager dbManager = DatabaseManager.getInstance();
        this.handleUsernameAndPassword(dbManager, username, password, secureRandom);
        if (!dropFirst && schema.isSchemaMismatched(collection.getName(), schema, this.getContext())) {
            String message = "Table schema mismatch for existing collection.";
            JSONStoreSchemaMismatchException jsException = new JSONStoreSchemaMismatchException(message);
            this.logger.logTrace(message);
            throw jsException;
        }
        if (!dbManager.provisionDatabase(this.getContext(), schema, dropFirst)) {
            try {
                dbManager.getDatabase(collection.getName()).getReadableDatabase();
            }
            catch (Exception e) {
                String message = "Could not retreive a database accessor.";
                JSONStoreFileAccessException jsException = new JSONStoreFileAccessException(message, e);
                this.logger.logTrace(message);
                throw jsException;
            }
            return false;
        }
        return true;
    }

    private void handleUsernameAndPassword(DatabaseManager dbManager, String username, String password, String secureRandom) throws JSONStoreCloseAllException, JSONStoreInvalidPasswordException {
        if (username == null) {
            if (dbManager.getDbPath() == null) {
                dbManager.setDbPath("jsonstore.sqlite");
            }
            if (!dbManager.getDbPath().equalsIgnoreCase("jsonstore.sqlite")) {
                String message = "You tried to login with a user that is not the default user that is currently logged in. Call closeAll first.";
                JSONStoreCloseAllException jsException = new JSONStoreCloseAllException(message);
                this.logger.logTrace(message);
                throw jsException;
            }
        } else if (dbManager.getDbPath() == null) {
            dbManager.setDbPath(username);
        } else if (!dbManager.getDbPath().equals(username + ".sqlite")) {
            String message = "You tried to login with a user that is not " + dbManager.getDbPath() + ". Call closeAll first.";
            JSONStoreCloseAllException jsException = new JSONStoreCloseAllException(message);
            this.logger.logTrace(message);
            throw jsException;
        }
        if (password != null && !password.equals("")) {
            String salt = SecurityUtils.getRandomString(32);
            try {
                if (!SecurityManager.getInstance(this.getContext()).isDPKAvailable(username)) {
                    SecurityManager.getInstance(this.getContext()).storeDPK(password, username, secureRandom, salt, false);
                }
                dbManager.setDatabaseKey(this.getContext(), password, username);
            }
            catch (Throwable e) {
                String message = "Error setting key.";
                JSONStoreInvalidPasswordException jsException = new JSONStoreInvalidPasswordException(message, e);
                this.logger.logTrace(message);
                throw jsException;
            }
        }
    }

    private void disownAllCollections() {
        for (JSONStoreCollection col : this.collectionMap.values()) {
            col.disown();
        }
        this.collectionMap.clear();
    }

    void removeCollectionReference(JSONStoreCollection col) {
        col.disown();
        this.collectionMap.remove(col);
    }

    public static WLJSONStore getInstance(Context android_context) {
        if (instance == null) {
            WLUtils.loadLib(android_context, LIBCRYPTO_FILE_NAME);
            instance = new WLJSONStore(android_context);
        }
        return instance;
    }

    public void openCollections(List<JSONStoreCollection> collections, JSONStoreInitOptions initOptions) throws JSONStoreInvalidSchemaException, JSONStoreFileAccessException, JSONStoreMigrationException, JSONStoreCloseAllException, JSONStoreInvalidPasswordException, JSONStoreSchemaMismatchException, JSONStoreTransactionDuringInitException {
        if (transactionInProgress) {
            throw new JSONStoreTransactionDuringInitException("Cannot open collections while executing a transaction.");
        }
        if (collections == null) {
            return;
        }
        boolean dropFirst = false;
        String password = null;
        String secureRandom = null;
        if (initOptions == null) {
            initOptions = new JSONStoreInitOptions();
        }
        dropFirst = initOptions.isClear();
        password = initOptions.getPassword();
        this.username = initOptions.getUsername();
        secureRandom = initOptions.getSecureRandom();
        JSONStoreLogger.setAnalyticsEnabled(initOptions.isAnalyticsEnabled());
        for (JSONStoreCollection collection : collections) {
            DatabaseSchema schema = null;
            if (collection == null) continue;
            JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, collection.getName(), JSONStoreLogger.OPERATION_OPEN);
            try {
                schema = new DatabaseSchema(collection.getName(), collection.getAllSearchFields());
            }
            catch (Throwable e) {
                String message = "Error when validating schema.";
                JSONStoreInvalidSchemaException jsException = new JSONStoreInvalidSchemaException(message, e);
                this.logger.logTrace(message);
                throw jsException;
            }
            boolean wasReopened = this.provisionDatabase(collection, schema, this.username, password, dropFirst, secureRandom);
            this.collectionMap.put(collection.getName(), collection);
            collection.initialize(this, schema, wasReopened);
            logInst.end();
        }
    }

    public void openCollections(List<JSONStoreCollection> collections) throws JSONStoreInvalidSchemaException, JSONStoreFileAccessException, JSONStoreMigrationException, JSONStoreCloseAllException, JSONStoreInvalidPasswordException, JSONStoreSchemaMismatchException, JSONStoreTransactionDuringInitException {
        this.openCollections(collections, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws JSONStoreCloseAllException, JSONStoreDatabaseClosedException, JSONStoreTransactionFailureException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, "", JSONStoreLogger.OPERATION_CLOSE_ALL);
        try {
            if (transactionInProgress) {
                throw new JSONStoreTransactionFailureException("Cannot close collections while executing a transaction.");
            }
            DatabaseManager dbManager = DatabaseManager.getInstance();
            if (!dbManager.isDatabaseOpen()) {
                String message = "Could not close all collections. The database is not open.";
                JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
                this.logger.logTrace(message);
                throw jsException;
            }
            try {
                dbManager.clearDbPath();
                dbManager.clearDatabaseKey();
                dbManager.closeDatabase();
                this.disownAllCollections();
            }
            catch (Throwable e) {
                String message = "Could not close the database. An exception occurred.";
                JSONStoreCloseAllException jsException = new JSONStoreCloseAllException(message, e);
                this.logger.logTrace(message);
                throw jsException;
            }
        }
        finally {
            logInst.end();
        }
    }

    public JSONStoreCollection getCollectionByName(String collectionName) {
        JSONStoreCollection col = this.collectionMap.get(collectionName);
        if (col == null) {
            return null;
        }
        try {
            DatabaseManager.getInstance().getDatabase(collectionName);
        }
        catch (Exception e) {
            this.removeCollectionReference(col);
            return null;
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws JSONStoreDestroyFailureException, JSONStoreTransactionFailureException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, "", JSONStoreLogger.OPERATION_DESTROY);
        try {
            if (transactionInProgress) {
                throw new JSONStoreTransactionFailureException("Cannot destroy store while executing a transaction.");
            }
            DatabaseManager dbManager = DatabaseManager.getInstance();
            dbManager.destroyKeychain(this.getContext());
            dbManager.destroyPreferences(this.getContext());
            dbManager.clearDbPath();
            dbManager.clearDatabaseKey();
            if (dbManager.isDatabaseOpen()) {
                dbManager.closeDatabase();
            }
            this.disownAllCollections();
            transactionInProgress = false;
            int result = dbManager.destroyDatabase(this.getContext());
            if (result != 0) {
                String message = "There was an error when destroying the JSONStore. The destroyDatabase failed.";
                JSONStoreDestroyFailureException jsException = new JSONStoreDestroyFailureException(message);
                this.logger.logTrace(message);
                throw jsException;
            }
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONStoreFileInfo> getFileInfo() {
        TreeMap<String, JSONStoreFileInfo> results = new TreeMap<String, JSONStoreFileInfo>();
        File dbBaseDir = this.context.getDatabasePath("wljsonstore");
        FileInputStream in = null;
        if (dbBaseDir.exists() && dbBaseDir.isDirectory()) {
            File[] subFiles;
            for (File possibleDB : subFiles = dbBaseDir.listFiles()) {
                if (possibleDB == null || !possibleDB.isFile() || !possibleDB.getName().endsWith(".sqlite")) continue;
                String name = possibleDB.getName();
                String username = name.substring(0, name.length() - ".sqlite".length());
                long fileSizeBytes = possibleDB.length();
                boolean isEncrypted = true;
                try {
                    in = new FileInputStream(possibleDB);
                    byte[] first6Bytes = new byte[6];
                    in.read(first6Bytes, 0, 6);
                    String first16String = new String(first6Bytes);
                    if (first16String.equalsIgnoreCase("SQLite")) {
                        isEncrypted = false;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                JSONStoreFileInfo currentDB = new JSONStoreFileInfo(username, fileSizeBytes, isEncrypted);
                results.put(username, currentDB);
            }
        }
        return new ArrayList<JSONStoreFileInfo>(results.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startTransaction() throws JSONStoreTransactionInProgressException, JSONStoreTransactionFailureException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, "", JSONStoreLogger.OPERATION_START_TRANSACTION);
        try {
            DatabaseAccessor acc = null;
            try {
                acc = DatabaseManager.getInstance().getDatabase();
            }
            catch (Exception e) {
                throw new JSONStoreDatabaseClosedException();
            }
            if (this.isTransactionInProgress()) {
                throw new JSONStoreTransactionInProgressException("Cannot start a new transaction; a transaction is already in progress.");
            }
            try {
                acc.getRawDatabase().beginTransaction();
                transactionInProgress = true;
            }
            catch (Throwable e) {
                throw new JSONStoreTransactionFailureException(e);
            }
        }
        finally {
            logInst.end();
        }
    }

    public synchronized boolean isTransactionInProgress() {
        return transactionInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commitTransaction() throws JSONStoreNoTransactionInProgressException, JSONStoreTransactionFailureException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, "", JSONStoreLogger.OPERATION_COMMIT_TRANSACTION);
        try {
            DatabaseAccessor acc = null;
            try {
                acc = DatabaseManager.getInstance().getDatabase();
            }
            catch (Exception e) {
                throw new JSONStoreDatabaseClosedException();
            }
            if (!this.isTransactionInProgress()) {
                throw new JSONStoreNoTransactionInProgressException("No transaction in progress; cannot commit transaction.");
            }
            try {
                acc.getRawDatabase().setTransactionSuccessful();
                acc.getRawDatabase().endTransaction();
                transactionInProgress = false;
            }
            catch (Throwable e) {
                throw new JSONStoreTransactionFailureException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rollbackTransaction() throws JSONStoreNoTransactionInProgressException, JSONStoreDatabaseClosedException, JSONStoreTransactionFailureException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.username, "", JSONStoreLogger.OPERATION_ROLLBACK_TRANSACTION);
        try {
            DatabaseAccessor acc = null;
            try {
                acc = DatabaseManager.getInstance().getDatabase();
            }
            catch (Exception e) {
                throw new JSONStoreDatabaseClosedException();
            }
            if (!this.isTransactionInProgress()) {
                throw new JSONStoreNoTransactionInProgressException("No transaction in progress; cannot roll back transaction.");
            }
            try {
                acc.getRawDatabase().endTransaction();
                transactionInProgress = false;
            }
            catch (Throwable e) {
                throw new JSONStoreTransactionFailureException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String username, String old_password, String new_password) throws JSONStoreDatabaseClosedException, JSONStoreChangePasswordException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(username, "", JSONStoreLogger.OPERATION_CHANGE_PASSWORD);
        try {
            try {
                DatabaseAccessor acc = DatabaseManager.getInstance().getDatabase();
                if (!DatabaseManager.getInstance().isDatabaseOpen()) {
                    throw new JSONStoreDatabaseClosedException();
                }
            }
            catch (Exception e) {
                throw new JSONStoreDatabaseClosedException();
            }
            SecurityManager secManager = SecurityManager.getInstance(this.context);
            try {
                String oldDPK = secManager.getDPK(old_password, username);
                String salt = secManager.getSalt(username);
                secManager.storeDPK(new_password, username, oldDPK, salt, true);
            }
            catch (Throwable t) {
                throw new JSONStoreChangePasswordException(t);
            }
        }
        finally {
            logInst.end();
        }
    }

    public void setAnalyticsEnabled(boolean isAnalyticsEnabled) {
        JSONStoreLogger.setAnalyticsEnabled(isAnalyticsEnabled);
    }
}

