/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import com.worklight.jsonstore.api.JSONStoreQueryPart;
import com.worklight.jsonstore.exceptions.JSONStoreFindException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreQueryParts {
    private List<JSONStoreQueryPart> parts;

    public JSONStoreQueryParts() {
        this.parts = new ArrayList<JSONStoreQueryPart>();
    }

    public JSONStoreQueryParts(JSONArray query) throws JSONStoreFindException {
        if (query == null) {
            this.parts = new ArrayList<JSONStoreQueryPart>();
        } else {
            this.parts = new ArrayList<JSONStoreQueryPart>(query.length());
            for (int i = 0; i < query.length(); ++i) {
                JSONObject queryPart = null;
                try {
                    queryPart = query.getJSONObject(i);
                }
                catch (JSONException e) {
                    throw new JSONStoreFindException("Value in query at index " + i + " is not a JSON Object", e);
                }
                this.parts.add(new JSONStoreQueryPart(queryPart));
            }
        }
    }

    public void addQueryPart(JSONStoreQueryPart part) {
        if (part != null) {
            this.parts.add(part);
        }
    }

    public List<JSONStoreQueryPart> getAllQueryParts() {
        return this.parts;
    }
}

