/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import com.worklight.jsonstore.api.JSONStoreQueryPartItem;
import com.worklight.jsonstore.database.QueryPartOperation;
import com.worklight.jsonstore.exceptions.JSONStoreFindException;
import com.worklight.jsonstore.util.JSONStoreLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreQueryPart {
    private static final String EXCEPTION_VALUE_MUST_NOT_BE_NULL = "Value must not be null";
    private static final String EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING = "Search field must be a nonempty string";
    private List<JSONStoreQueryPartItem> queryItems = new LinkedList<JSONStoreQueryPartItem>();

    public JSONStoreQueryPart() {
    }

    public JSONStoreQueryPart(JSONObject part) throws JSONStoreFindException {
        QueryPartOperation[] operations = QueryPartOperation.values();
        for (int i = 0; i < operations.length; ++i) {
            this.parse(part, operations[i], this.queryItems);
        }
    }

    void addRawItem(String search_field, boolean is_special, QueryPartOperation operation, Object val) {
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, is_special, operation, val));
    }

    public void addLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_EQUALS, val));
    }

    public void addLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_EQUALS, val));
    }

    public void addLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_EQUALS, val));
    }

    public void addNotLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_EQUALS, val));
    }

    public void addNotLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_EQUALS, val));
    }

    public void addNotLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_EQUALS, val));
    }

    public void addRightLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_RIGHT_EQUALS, val));
    }

    public void addRightLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_RIGHT_EQUALS, val));
    }

    public void addRightLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_RIGHT_EQUALS, val));
    }

    public void addNotRightLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_RIGHT_EQUALS, val));
    }

    public void addNotRightLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_RIGHT_EQUALS, val));
    }

    public void addNotRightLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_RIGHT_EQUALS, val));
    }

    public void addLeftLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_LEFT_EQUALS, val));
    }

    public void addLeftLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_LEFT_EQUALS, val));
    }

    public void addLeftLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_LEFT_EQUALS, val));
    }

    public void addNotLeftLike(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_LEFT_EQUALS, val));
    }

    public void addNotLeftLike(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_LEFT_EQUALS, val));
    }

    public void addNotLeftLike(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.FUZZY_NOT_LEFT_EQUALS, val));
    }

    public void addEqual(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_EQUALS, val));
    }

    public void addEqual(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_EQUALS, val));
    }

    public void addEqual(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_EQUALS, val));
    }

    public void addNotEqual(String search_field, String val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_NOT_EQUALS, val));
    }

    public void addNotEqual(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_NOT_EQUALS, val));
    }

    public void addNotEqual(String search_field, Boolean val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.EXACT_NOT_EQUALS, val));
    }

    public void addLessThan(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.LESS_THAN, val));
    }

    public void addLessThanOrEqual(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.LESS_THAN_OR_EQUALS, val));
    }

    public void addGreaterThan(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.GREATER_THAN, val));
    }

    public void addGreaterThanOrEqual(String search_field, Number val) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException(EXCEPTION_SEARCH_FIELD_MUST_BE_A_NONEMPTY_STRING);
        }
        if (val == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.GREATER_THAN_OR_EQUALS, val));
    }

    public void addBetween(String search_field, Number start, Number end) {
        if (start == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        if (end == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        ArrayList<Number> rangeList = new ArrayList<Number>(2);
        rangeList.add(start);
        rangeList.add(end);
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.BETWEEN, rangeList));
    }

    public void addNotBetween(String search_field, Number start, Number end) {
        if (start == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        if (end == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        ArrayList<Number> rangeList = new ArrayList<Number>(2);
        rangeList.add(start);
        rangeList.add(end);
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.NOT_BETWEEN, rangeList));
    }

    public void addInside(String search_field, List<Object> values) {
        if (values == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        ArrayList<Object> valuesChecked = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (value == null || !(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
            valuesChecked.add(value);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.IN, valuesChecked));
    }

    public void addNotInside(String search_field, List<Object> values) {
        if (values == null) {
            throw new IllegalArgumentException(EXCEPTION_VALUE_MUST_NOT_BE_NULL);
        }
        ArrayList<Object> valuesChecked = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (value == null || !(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
            valuesChecked.add(value);
        }
        this.queryItems.add(new JSONStoreQueryPartItem(search_field, false, QueryPartOperation.NOT_IN, valuesChecked));
    }

    public List<JSONStoreQueryPartItem> getQueryBlockItems() {
        return this.queryItems;
    }

    private boolean isObjectPrimitive(Object obj) {
        return !(obj instanceof JSONArray) && !(obj instanceof JSONObject);
    }

    private JSONStoreQueryPartItem parseItem(String key, boolean is_key_special, QueryPartOperation operation, Object val) throws JSONStoreFindException {
        try {
            switch (operation.getRestriction()) {
                case ARRAY_ONLY: {
                    if (!(val instanceof JSONArray)) {
                        throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " must be an array", null);
                    }
                    JSONArray valAsArray = (JSONArray)val;
                    ArrayList<Object> convertedObjectsList = new ArrayList<Object>(valAsArray.length());
                    for (int i = 0; i < valAsArray.length(); ++i) {
                        try {
                            Object o = valAsArray.get(i);
                            if (!this.isObjectPrimitive(o)) {
                                throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " at index " + i + "cannot be an JSONArray or JSONObject", null);
                            }
                            convertedObjectsList.add(o);
                            continue;
                        }
                        catch (JSONException e) {
                            throw new JSONStoreFindException("Cannot parse query content part. An internal error occured", e);
                        }
                    }
                    val = convertedObjectsList;
                    break;
                }
                case RANGE_ONLY: {
                    if (!(val instanceof JSONArray)) {
                        throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " must be an array", null);
                    }
                    JSONArray arr = (JSONArray)val;
                    if (arr.length() != 2) {
                        throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " must be an array of size 2", null);
                    }
                    try {
                        Object firstNumber = arr.get(0);
                        Object secondNumber = arr.get(1);
                        if (!this.isObjectPrimitive(firstNumber) || !this.isObjectPrimitive(secondNumber)) {
                            throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " must be an array of size 2 primitives", null);
                        }
                        ArrayList<Object> rangeList = new ArrayList<Object>(2);
                        rangeList.add(firstNumber);
                        rangeList.add(secondNumber);
                        val = rangeList;
                        break;
                    }
                    catch (JSONException e) {
                        throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " caused an internal error ", e);
                    }
                }
                case PRIMITIVE_ONLY: {
                    if (this.isObjectPrimitive(val)) break;
                    throw new JSONStoreFindException("Cannot parse query content part. Tuple with key " + key + " cannot be an array or object", null);
                }
            }
        }
        catch (JSONStoreFindException e) {
            JSONStoreLogger.getLogger("QueryContentPart").logTrace("Invalid syntax: " + e.getMessage());
            return null;
        }
        return new JSONStoreQueryPartItem(key, false, operation, val);
    }

    private void parseTuple(JSONObject tuple, QueryPartOperation operation, List<JSONStoreQueryPartItem> result) throws JSONStoreFindException {
        if (tuple.length() == 0) {
            throw new JSONStoreFindException("Cannot parse query content part. An internal error occurred parsing part tuple", null);
        }
        Iterator tupleIterator = tuple.keys();
        while (tupleIterator.hasNext()) {
            Object val;
            String key = (String)tupleIterator.next();
            try {
                val = tuple.get(key);
            }
            catch (JSONException e) {
                throw new JSONStoreFindException("Cannot parse query content query part. An internal error occurred parsing part tuple", e);
            }
            JSONStoreQueryPartItem part = this.parseItem(key, false, operation, val);
            if (part == null) continue;
            result.add(part);
        }
    }

    private void parse(JSONObject incoming, QueryPartOperation operation, List<JSONStoreQueryPartItem> results) throws JSONStoreFindException {
        if (incoming == null || operation == null || results == null) {
            return;
        }
        Iterator incomingKeyIterator = incoming.keys();
        while (incomingKeyIterator.hasNext()) {
            String currentIncomingKey = (String)incomingKeyIterator.next();
            if (!operation.queryStringMatches(currentIncomingKey)) continue;
            JSONArray operationArray = null;
            try {
                operationArray = incoming.getJSONArray(currentIncomingKey);
            }
            catch (JSONException e) {
                throw new JSONStoreFindException("Cannot parse query content part. " + currentIncomingKey + " query must be a json array.", e);
            }
            for (int i = 0; i < operationArray.length(); ++i) {
                JSONObject operationTuple = null;
                try {
                    operationTuple = operationArray.getJSONObject(i);
                }
                catch (JSONException e) {
                    throw new JSONStoreFindException("Cannot parse query content part. " + currentIncomingKey + " query must contain a JSON object at index " + i, e);
                }
                this.parseTuple(operationTuple, operation, results);
            }
        }
    }
}

