/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import com.worklight.jsonstore.database.SortDirection;
import com.worklight.jsonstore.exceptions.JSONStoreInvalidSortObjectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONStoreFindOptions {
    private static final String OPTION_LIMIT = "limit";
    private static final String OPTION_OFFSET = "offset";
    private static final String OPTION_SORT_ARRAY = "sort";
    private static final String OPTION_FILTER = "filter";
    private Integer limit;
    private Integer offset;
    private LinkedHashMap<String, SortDirection> sort;
    private Map<String, Boolean> filter;
    private boolean includeDeleted = false;

    public JSONStoreFindOptions() {
        this.limit = null;
        this.offset = null;
        this.filter = new HashMap<String, Boolean>();
        this.sort = new LinkedHashMap();
    }

    public JSONStoreFindOptions(JSONObject options) throws JSONException, JSONStoreInvalidSortObjectException {
        JSONArray filterParse;
        JSONArray sortArray;
        String offsetStr;
        this.filter = new HashMap<String, Boolean>();
        this.sort = new LinkedHashMap();
        String limitStr = options.optString(OPTION_LIMIT, null);
        if (limitStr != null) {
            Integer limitParse = Integer.parseInt(limitStr);
            this.setLimit(limitParse);
        }
        if ((offsetStr = options.optString(OPTION_OFFSET, null)) != null) {
            Integer offsetParse = Integer.parseInt(offsetStr);
            this.setOffset(offsetParse);
        }
        if ((sortArray = options.optJSONArray(OPTION_SORT_ARRAY)) != null) {
            for (int idx = 0; idx < sortArray.length(); ++idx) {
                JSONObject sortObject = sortArray.getJSONObject(idx);
                Iterator keys = sortObject.keys();
                String key = (String)keys.next();
                if (keys.hasNext()) {
                    throw new JSONStoreInvalidSortObjectException("One of the sort objects in the sort array has more than one field.");
                }
                String sortDirectionStr = sortObject.getString(key);
                if (sortDirectionStr.equalsIgnoreCase("ASC")) {
                    this.sortBySearchFieldAscending(key);
                    continue;
                }
                if (sortDirectionStr.equalsIgnoreCase("DESC")) {
                    this.sortBySearchFieldDescending(key);
                    continue;
                }
                throw new JSONStoreInvalidSortObjectException("Invalid sorting direction (ascending or descending) specified.");
            }
        }
        if ((filterParse = options.optJSONArray(OPTION_FILTER)) != null) {
            for (int idx = 0; idx < filterParse.length(); ++idx) {
                this.addSearchFilter(filterParse.getString(idx));
            }
        }
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public LinkedHashMap<String, SortDirection> getSort() {
        return this.sort;
    }

    public void sortBySearchFieldAscending(String search_field) {
        this.sort.put(search_field, SortDirection.ASCENDING);
    }

    public void sortBySearchFieldDescending(String search_field) {
        this.sort.put(search_field, SortDirection.DESCENDING);
    }

    Map<String, Boolean> getSearchFilters() {
        return this.filter;
    }

    public void setSearchFilters(List<String> filters) {
        this.filter.clear();
        for (String currentFilter : filters) {
            this.filter.put(currentFilter, false);
        }
    }

    public void addSearchFilter(String new_filter) {
        this.filter.put(new_filter, false);
    }

    void addSearchFilterSpecial(String new_filter) {
        this.filter.put(new_filter, true);
    }

    public void includeDeletedDocuments(boolean include) {
        this.includeDeleted = include;
    }

    public boolean shouldIncludeDeletedDocuments() {
        return this.includeDeleted;
    }
}

