/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import android.content.ContentValues;
import android.database.Cursor;
import com.worklight.jsonstore.api.JSONStoreAddOptions;
import com.worklight.jsonstore.api.JSONStoreChangeOptions;
import com.worklight.jsonstore.api.JSONStoreCountOptions;
import com.worklight.jsonstore.api.JSONStoreFindOptions;
import com.worklight.jsonstore.api.JSONStoreQueryPart;
import com.worklight.jsonstore.api.JSONStoreQueryParts;
import com.worklight.jsonstore.api.JSONStoreRemoveOptions;
import com.worklight.jsonstore.api.JSONStoreReplaceOptions;
import com.worklight.jsonstore.api.WLJSONStore;
import com.worklight.jsonstore.database.DatabaseAccessor;
import com.worklight.jsonstore.database.DatabaseManager;
import com.worklight.jsonstore.database.DatabaseSchema;
import com.worklight.jsonstore.database.QueryBuilder;
import com.worklight.jsonstore.database.QueryBuilderSelect;
import com.worklight.jsonstore.database.SearchFieldType;
import com.worklight.jsonstore.database.WritableDatabase;
import com.worklight.jsonstore.exceptions.JSONStoreAddException;
import com.worklight.jsonstore.exceptions.JSONStoreChangeException;
import com.worklight.jsonstore.exceptions.JSONStoreCountException;
import com.worklight.jsonstore.exceptions.JSONStoreDatabaseClosedException;
import com.worklight.jsonstore.exceptions.JSONStoreDirtyCheckException;
import com.worklight.jsonstore.exceptions.JSONStoreException;
import com.worklight.jsonstore.exceptions.JSONStoreFilterException;
import com.worklight.jsonstore.exceptions.JSONStoreFindException;
import com.worklight.jsonstore.exceptions.JSONStoreInvalidSchemaException;
import com.worklight.jsonstore.exceptions.JSONStoreMarkCleanException;
import com.worklight.jsonstore.exceptions.JSONStoreRemoveCollectionException;
import com.worklight.jsonstore.exceptions.JSONStoreRemoveException;
import com.worklight.jsonstore.exceptions.JSONStoreReplaceException;
import com.worklight.jsonstore.exceptions.JSONStoreTransactionFailureException;
import com.worklight.jsonstore.jackson.JacksonSerializedJSONObject;
import com.worklight.jsonstore.jackson.JsonOrgModule;
import com.worklight.jsonstore.util.JSONStoreLogger;
import com.worklight.jsonstore.util.JSONStoreUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sqlcipher.database.SQLiteDatabase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreCollection {
    private static final int FIND_BY_ID_CHUNK_SIZE = 200;
    private String name;
    private Map<String, SearchFieldType> searchFields;
    private Map<String, SearchFieldType> additionalSearchFields;
    private WLJSONStore initializedJSONStoreInstance;
    private boolean wasReopened;
    private DatabaseSchema schema;
    private JSONStoreLogger logger = JSONStoreUtil.getCoreLogger();

    public JSONStoreCollection(String name) throws JSONStoreInvalidSchemaException {
        this.searchFields = new HashMap<String, SearchFieldType>();
        this.additionalSearchFields = new HashMap<String, SearchFieldType>();
        if (name == null || name.isEmpty()) {
            String message = "Error when creating the collection. Collection name cannot be null.";
            JSONStoreInvalidSchemaException jsException = new JSONStoreInvalidSchemaException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        this.name = name;
    }

    private Cursor runQuery(QueryBuilder selectQuery) throws JSONStoreDatabaseClosedException {
        if (selectQuery == null) {
            return null;
        }
        DatabaseAccessor acc = this.getAccessor();
        StringBuilder rawQueryString = new StringBuilder();
        LinkedList<String> rawQueryParams = new LinkedList<String>();
        selectQuery.convertToQueryString(rawQueryString, rawQueryParams);
        String[] rawQueryParamsArray = rawQueryParams.toArray(new String[rawQueryParams.size()]);
        return acc.getRawDatabase().rawQuery(rawQueryString.toString(), rawQueryParamsArray);
    }

    private DatabaseAccessor getAccessor() throws JSONStoreDatabaseClosedException {
        if (this.initializedJSONStoreInstance == null) {
            String message = "Collection is not initialized.";
            JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        DatabaseManager mgr = DatabaseManager.getInstance();
        if (mgr == null || !mgr.isDatabaseOpen()) {
            String message = "Database manager is null or database not opened.";
            JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        DatabaseAccessor acc = null;
        try {
            acc = mgr.getDatabase(this.getName());
        }
        catch (Exception e) {
            String message = "Could not get database accessor. Database is not open.";
            JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        if (acc == null) {
            String message = "Database accessor is not open. The database is not open.";
            JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        SQLiteDatabase rawDB = acc.getRawDatabase();
        if (rawDB == null || !rawDB.isOpen()) {
            String message = "Could not get raw collection instance. The database is not open.";
            JSONStoreDatabaseClosedException jsException = new JSONStoreDatabaseClosedException(message);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        return acc;
    }

    private boolean isJSONCreatedColumn(String column) {
        return column.equals("_deleted") || column.equals("_dirty") || column.equals("_id") || column.equals("json") || column.equals("_operation");
    }

    private List<JSONObject> removeFilterDuplicates(List<JSONObject> list) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (JSONObject obj : list) {
            if (map.containsKey(obj.toString())) continue;
            map.put(obj.toString(), true);
            result.add(obj);
        }
        return result;
    }

    private void addNonDuplicates(LinkedHashMap<Integer, JSONObject> resultHash, List<JSONObject> results) throws JSONStoreFindException {
        try {
            if (results != null) {
                for (JSONObject jso : results) {
                    Integer id = jso.getInt("_id");
                    if (resultHash.containsKey(id)) continue;
                    resultHash.put(id, jso);
                }
            }
        }
        catch (JSONException e) {
            String message = "Error when attempting to find a document. A JSONException occurred.";
            JSONStoreFindException jsException = new JSONStoreFindException(message, e);
            this.logger.logError(message, jsException);
            throw jsException;
        }
    }

    void initialize(WLJSONStore instance, DatabaseSchema schema, boolean reopened) {
        this.initializedJSONStoreInstance = instance;
        this.schema = schema;
        this.wasReopened = reopened;
    }

    void disown() {
        this.initializedJSONStoreInstance = null;
    }

    private String getUsername() {
        if (this.initializedJSONStoreInstance != null) {
            return this.initializedJSONStoreInstance.getUsername();
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public boolean wasReopened() {
        return this.wasReopened;
    }

    public Map<String, SearchFieldType> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchField(String key, SearchFieldType type) {
        if (key == null || key.isEmpty()) {
            return;
        }
        type = type != null ? type : SearchFieldType.STRING;
        this.searchFields.put(key, type);
    }

    public boolean hasSearchField(String search_field) {
        if (search_field.equals("_deleted") || search_field.equals("_id") || search_field.equals("_dirty") || search_field.equals("_operation")) {
            return true;
        }
        return this.searchFields.containsKey(search_field);
    }

    public void setAdditionalSearchField(String key, SearchFieldType type) {
        type = type != null ? type : SearchFieldType.STRING;
        this.additionalSearchFields.put(key, type);
    }

    public Map<String, SearchFieldType> getAdditionalSearchFields() {
        return this.additionalSearchFields;
    }

    public boolean hasAdditionalSearchField(String additional_search_field) {
        return this.additionalSearchFields.containsKey(additional_search_field);
    }

    protected Map<String, SearchFieldType> getAllSearchFields() {
        SearchFieldType value;
        String name;
        HashMap<String, SearchFieldType> allSearchFields = new HashMap<String, SearchFieldType>();
        for (Map.Entry<String, SearchFieldType> entry : this.searchFields.entrySet()) {
            name = entry.getKey();
            value = entry.getValue();
            allSearchFields.put(name, value);
        }
        if (this.additionalSearchFields != null) {
            for (Map.Entry<String, SearchFieldType> entry : this.additionalSearchFields.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                allSearchFields.put(name, value);
            }
        }
        return allSearchFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection() throws JSONStoreRemoveCollectionException, JSONStoreDatabaseClosedException, JSONStoreTransactionFailureException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_REMOVE_COLLECTION);
        try {
            DatabaseAccessor acc = this.getAccessor();
            if (this.initializedJSONStoreInstance.isTransactionInProgress()) {
                throw new JSONStoreTransactionFailureException("Cannot remove collection during a transaction.");
            }
            acc.dropTable();
            this.initializedJSONStoreInstance.removeCollectionReference(this);
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCollection() throws JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_CLEAR);
        try {
            DatabaseAccessor acc = this.getAccessor();
            acc.getRawDatabase().delete(this.getName(), "1", new String[0]);
        }
        finally {
            logInst.end();
        }
    }

    public int changeData(JSONObject[] data) throws JSONStoreChangeException, JSONStoreDatabaseClosedException, JSONException {
        return this.changeData(data, null);
    }

    public int changeData(JSONObject[] data, JSONStoreChangeOptions options) throws JSONStoreChangeException, JSONStoreDatabaseClosedException, JSONException {
        return this.changeData(JSONStoreUtil.convertJSONObjectArrayToJSONObjectList(data), options);
    }

    public int changeData(List<JSONObject> data) throws JSONStoreChangeException, JSONStoreDatabaseClosedException, JSONException {
        return this.changeData(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeData(List<JSONObject> data, JSONStoreChangeOptions options) throws JSONStoreChangeException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_CHANGE);
        try {
            List<String> replaceCriteria;
            this.getAccessor();
            if (options == null) {
                options = new JSONStoreChangeOptions();
            }
            if (data == null) {
                int n = 0;
                return n;
            }
            int changeCount = 0;
            if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                DatabaseAccessor databaseAccessor = this.getAccessor();
                synchronized (databaseAccessor) {
                    this.getAccessor().getRawDatabase().beginTransaction();
                }
            }
            if ((replaceCriteria = options.getSearchFieldCriteria()) == null || replaceCriteria.size() == 0) {
                replaceCriteria = new LinkedList<String>();
                for (String searchField : this.getSearchFields().keySet()) {
                    replaceCriteria.add(searchField);
                }
                for (String additionalSearchField : this.getAdditionalSearchFields().keySet()) {
                    replaceCriteria.add(additionalSearchField);
                }
            }
            for (String replaceKey : replaceCriteria) {
                if (this.getSearchFields().containsKey(replaceKey) || this.getAdditionalSearchFields().containsKey(replaceKey)) continue;
                String message = "Replace criteria '" + replaceKey + "' must be a search field or additional search field.";
                JSONStoreChangeException jsException = new JSONStoreChangeException(message);
                this.logger.logError(message, jsException);
                throw jsException;
            }
            LinkedList<JSONObject> allReplaceObjects = new LinkedList<JSONObject>();
            LinkedList<JSONObject> allAddObjects = new LinkedList<JSONObject>();
            for (JSONObject currentData : data) {
                JSONStoreQueryParts queryContent = new JSONStoreQueryParts();
                JSONStoreQueryPart queryContentPart = new JSONStoreQueryPart();
                for (String criteria : replaceCriteria) {
                    if (!currentData.has(criteria)) continue;
                    Object val = currentData.get(criteria);
                    if (val instanceof Boolean) {
                        val = (Boolean)val != false ? 1 : 0;
                    }
                    queryContentPart.addEqual(criteria, val.toString());
                }
                queryContent.addQueryPart(queryContentPart);
                QueryBuilderSelect selectQuery = new QueryBuilderSelect(this, queryContent);
                selectQuery.addSelectStatement("_id", false);
                Cursor allDocIds = this.runQuery(selectQuery);
                if (allDocIds == null) continue;
                if (allDocIds.getCount() <= 0) {
                    allAddObjects.add(currentData);
                } else {
                    allDocIds.moveToFirst();
                    for (int i = 0; i < allDocIds.getCount() && !allDocIds.isAfterLast(); ++i) {
                        int idIndex = allDocIds.getColumnIndex("_id");
                        int replaceId = allDocIds.getInt(idIndex);
                        JSONObject fullUpdateDoc = new JSONObject();
                        fullUpdateDoc.put("json", (Object)currentData);
                        fullUpdateDoc.put("_id", replaceId);
                        allReplaceObjects.add(fullUpdateDoc);
                        allDocIds.moveToNext();
                    }
                }
                allDocIds.close();
            }
            JSONStoreReplaceOptions replaceOptions = new JSONStoreReplaceOptions();
            replaceOptions.setMarkDirty(options.isMarkDirty());
            for (JSONObject doc : allReplaceObjects) {
                try {
                    this.replaceDocument(doc, replaceOptions);
                    ++changeCount;
                }
                catch (JSONStoreReplaceException e) {
                    String message = "Failed to replace an existing document.";
                    JSONStoreChangeException jsException = new JSONStoreChangeException(message, e);
                    this.logger.logError(message, jsException);
                    throw jsException;
                }
            }
            JSONStoreAddOptions addOptions = new JSONStoreAddOptions();
            addOptions.setMarkDirty(options.isMarkDirty());
            if (options.isAddNew()) {
                for (JSONObject doc : allAddObjects) {
                    try {
                        this.addData(doc, addOptions);
                        ++changeCount;
                    }
                    catch (JSONStoreAddException e) {
                        String message = "Failed to add a new document.";
                        JSONStoreChangeException jsException = new JSONStoreChangeException(message, e);
                        this.logger.logError(message, jsException);
                        throw jsException;
                    }
                }
            }
            if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                DatabaseAccessor databaseAccessor = this.getAccessor();
                synchronized (databaseAccessor) {
                    this.getAccessor().getRawDatabase().setTransactionSuccessful();
                    this.getAccessor().getRawDatabase().endTransaction();
                }
            }
            int n = changeCount;
            return n;
        }
        finally {
            logInst.end();
        }
    }

    public JSONObject findDocumentById(int id) throws JSONStoreDatabaseClosedException, JSONStoreFindException {
        ArrayList<Integer> idList = new ArrayList<Integer>(1);
        idList.add(id);
        List<JSONObject> results = this.findDocumentsById(idList);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public List<JSONObject> findDocumentsById(int[] ids) throws JSONStoreDatabaseClosedException, JSONStoreFindException {
        if (ids == null) {
            ids = new int[]{};
        }
        ArrayList<Integer> docIdList = new ArrayList<Integer>(ids.length);
        return this.findDocumentsById(docIdList);
    }

    public List<JSONObject> findDocumentsById(List<Integer> ids) throws JSONStoreDatabaseClosedException, JSONStoreFindException {
        this.getAccessor();
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        List<List<Integer>> idChunks = JSONStoreUtil.splitListIntoChunks(ids, 200);
        for (List<Integer> idChunk : idChunks) {
            try {
                JSONStoreQueryParts content = new JSONStoreQueryParts();
                for (Integer id : idChunk) {
                    JSONStoreQueryPart part = new JSONStoreQueryPart();
                    part.addEqual("_id", id);
                    content.addQueryPart(part);
                }
                List<JSONObject> resultsRaw = this.findDocuments(content);
                HashMap<Integer, JSONObject> resultsMap = new HashMap<Integer, JSONObject>();
                for (JSONObject result : resultsRaw) {
                    resultsMap.put(result.getInt("_id"), result);
                }
                for (Integer id : ids) {
                    if (!resultsMap.containsKey(id)) continue;
                    resultList.add((JSONObject)resultsMap.get(id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public List<JSONObject> findAllDirtyDocuments() throws JSONStoreFindException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_FIND_ALL_DIRTY);
        try {
            this.getAccessor();
            JSONStoreQueryParts content = new JSONStoreQueryParts();
            JSONStoreQueryPart part = new JSONStoreQueryPart();
            part.addGreaterThan("_dirty", 0);
            content.addQueryPart(part);
            JSONStoreFindOptions options = new JSONStoreFindOptions();
            options.addSearchFilter("_id");
            options.addSearchFilter("json");
            options.addSearchFilter("_operation");
            options.addSearchFilter("_dirty");
            options.includeDeletedDocuments(true);
            try {
                List<JSONObject> list = this.findDocuments(content, options);
                return list;
            }
            catch (JSONStoreFilterException e) {
                throw new JSONStoreFindException("Error occured filtering results", e);
            }
        }
        finally {
            logInst.end();
        }
    }

    public List<JSONObject> findAllDocuments() throws JSONStoreFindException, JSONStoreDatabaseClosedException {
        return this.findAllDocuments(null);
    }

    public List<JSONObject> findAllDocuments(JSONStoreFindOptions options) throws JSONStoreFindException, JSONStoreDatabaseClosedException {
        this.getAccessor();
        try {
            return this.findDocuments(null, options);
        }
        catch (JSONStoreFilterException e) {
            throw new JSONStoreFindException("Error occured filtering results", e);
        }
    }

    public List<JSONObject> findDocuments(JSONStoreQueryParts query) throws JSONStoreFindException, JSONStoreFilterException, JSONStoreDatabaseClosedException {
        return this.findDocuments(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> findDocuments(JSONStoreQueryParts query, JSONStoreFindOptions options) throws JSONStoreFindException, JSONStoreFilterException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_FIND);
        try {
            this.getAccessor();
            if (options == null) {
                options = new JSONStoreFindOptions();
            }
            if (query == null) {
                query = new JSONStoreQueryParts();
            }
            QueryBuilderSelect selectQuery = new QueryBuilderSelect(this, query);
            selectQuery.setLimit(options.getLimit());
            selectQuery.setOffset(options.getOffset());
            selectQuery.setSort(options.getSort());
            if (options.shouldIncludeDeletedDocuments()) {
                selectQuery.setSearchIncludeDeleted();
            }
            LinkedHashMap<Integer, JSONObject> resultHash = new LinkedHashMap<Integer, JSONObject>();
            ArrayList<JSONObject> filterResults = new ArrayList<JSONObject>();
            Map<String, Boolean> filters = options.getSearchFilters();
            if (filters != null && filters.size() > 0) {
                for (String filter : filters.keySet()) {
                    boolean isSpecial = filters.get(filter);
                    selectQuery.addSelectStatement(filter, isSpecial);
                }
            } else {
                selectQuery.addSelectStatement("_id", false);
                selectQuery.addSelectStatement("json", false);
            }
            Cursor cursor = null;
            LinkedList<JSONObject> result = null;
            try {
                cursor = this.runQuery(selectQuery);
                if (cursor != null) {
                    result = new LinkedList<JSONObject>();
                    for (int j = 0; j < cursor.getCount(); ++j) {
                        JacksonSerializedJSONObject item = new JacksonSerializedJSONObject();
                        cursor.moveToNext();
                        for (int k = 0; k < cursor.getColumnNames().length; ++k) {
                            if (cursor.getColumnName(k).equals("_id")) {
                                item.put(cursor.getColumnName(k), cursor.getInt(k));
                                continue;
                            }
                            if (cursor.getColumnName(k).equals("json")) {
                                item.put("json", JsonOrgModule.deserializeJSONObject(cursor.getString(k)));
                                continue;
                            }
                            if (this.isJSONCreatedColumn(cursor.getColumnName(k))) {
                                item.put(cursor.getColumnName(k), cursor.getString(k));
                                continue;
                            }
                            item.put(cursor.getColumnName(k).replace("_", "."), cursor.getString(k));
                        }
                        result.add(item);
                    }
                }
            }
            catch (Throwable e) {
                String message = "Error when attempting to find a document. An error occurred when reading from the database.";
                JSONStoreFindException jsException = new JSONStoreFindException(message, e);
                this.logger.logError(message, jsException);
                throw jsException;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (options.getSearchFilters() != null) {
                for (JSONObject obj : result) {
                    filterResults.add(obj);
                }
            } else {
                this.addNonDuplicates(resultHash, result);
            }
            List<JSONObject> results = null;
            results = options.getSearchFilters() != null ? this.removeFilterDuplicates(filterResults) : new ArrayList<JSONObject>(resultHash.values());
            List<JSONObject> list = results;
            return list;
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDocumentDirty(int id) throws JSONStoreDirtyCheckException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_IS_DOCUMENT_DIRTY);
        try {
            List<JSONObject> result;
            this.getAccessor();
            JSONStoreQueryParts content = new JSONStoreQueryParts();
            JSONStoreQueryPart part = new JSONStoreQueryPart();
            part.addEqual("_id", id);
            part.addGreaterThan("_dirty", 0);
            content.addQueryPart(part);
            try {
                result = this.findDocuments(content);
            }
            catch (JSONStoreException e) {
                throw new JSONStoreDirtyCheckException("An error occured finding the document", e);
            }
            if (result.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int markDocumentsClean(JSONObject[] documents) throws JSONStoreMarkCleanException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_MARK_CLEAN);
        try {
            List<JSONObject> docs = JSONStoreUtil.convertJSONObjectArrayToJSONObjectList(documents);
            int n = this.markDocumentsClean(docs);
            return n;
        }
        finally {
            logInst.end();
        }
    }

    public int markDocumentsClean(List<JSONObject> documents) throws JSONStoreMarkCleanException, JSONStoreDatabaseClosedException {
        int numOfCleanDocs = 0;
        for (JSONObject doc : documents) {
            numOfCleanDocs += this.markDocumentClean(doc);
        }
        return numOfCleanDocs;
    }

    public int markDocumentClean(JSONObject document) throws JSONStoreMarkCleanException, JSONStoreDatabaseClosedException {
        int id;
        if (document == null) {
            return 0;
        }
        String operation = null;
        try {
            id = document.getInt("_id");
            operation = document.getString("_operation");
            if (operation == null) {
                String message = "Document does not contain the operation to execute.";
                JSONStoreMarkCleanException jsException = new JSONStoreMarkCleanException(message);
                this.logger.logError(message, jsException);
                throw jsException;
            }
        }
        catch (JSONException e) {
            String message = "Could not parse the document.";
            JSONStoreMarkCleanException jsException = new JSONStoreMarkCleanException(message, e);
            this.logger.logError(message, jsException);
            throw jsException;
        }
        DatabaseAccessor acc = this.getAccessor();
        WritableDatabase db = acc.getWritableDatabase();
        if (operation.equals("remove")) {
            db.delete(new String[]{"_id"}, new Object[]{id});
        }
        HashMap<String, Object> whereClauses = new HashMap<String, Object>();
        whereClauses.put("_id", id);
        db.update(new String[]{"_dirty", "_deleted", "_operation"}, new Object[]{0, 0, ""}, whereClauses);
        return 1;
    }

    public int countAllDocuments() throws JSONStoreCountException, JSONStoreDatabaseClosedException {
        return this.countDocuments(null, null);
    }

    public int countDocuments(JSONStoreQueryParts query) throws JSONStoreCountException, JSONStoreDatabaseClosedException {
        return this.countDocuments(query, null);
    }

    public int countDocuments(JSONStoreQueryParts query, JSONStoreCountOptions options) throws JSONStoreCountException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_COUNT);
        try {
            block13: {
                this.getAccessor();
                if (query == null) {
                    query = new JSONStoreQueryParts();
                }
                if (options == null) {
                    options = new JSONStoreCountOptions();
                }
                JSONStoreFindOptions findOptions = new JSONStoreFindOptions();
                if (options.shouldIncludeDeletedDocuments()) {
                    findOptions.includeDeletedDocuments(true);
                }
                findOptions.addSearchFilterSpecial("count(*)");
                List<JSONObject> results = this.findDocuments(query, findOptions);
                if (results == null || results.size() != 1) break block13;
                JSONObject countResults = results.get(0);
                if (countResults == null || countResults.opt("count(*)") == null) {
                    throw new JSONStoreCountException("Could not count the results. Missing count return value internally");
                }
                int n = countResults.getInt("count(*)");
                return n;
            }
            try {
                throw new JSONStoreCountException("Could not count the results. Missing results from find internally");
            }
            catch (JSONStoreFilterException e) {
                throw new JSONStoreCountException("Could not count the results. Filter exception occured internally", e);
            }
            catch (JSONStoreFindException e) {
                throw new JSONStoreCountException("Could not count the results. Find exception occured internally", e);
            }
            catch (JSONException e) {
                throw new JSONStoreCountException("Could not count the results. JSONException occured internally", e);
            }
        }
        finally {
            logInst.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAllDirtyDocuments() throws JSONStoreDatabaseClosedException, JSONStoreCountException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_COUNT_ALL_DIRTY);
        try {
            this.getAccessor();
            JSONStoreQueryParts queryContent = new JSONStoreQueryParts();
            JSONStoreQueryPart queryContentPart = new JSONStoreQueryPart();
            queryContentPart.addGreaterThan("_dirty", 0);
            queryContent.addQueryPart(queryContentPart);
            JSONStoreCountOptions options = new JSONStoreCountOptions();
            options.includeDeletedDocuments(true);
            int n = this.countDocuments(queryContent, options);
            return n;
        }
        finally {
            logInst.end();
        }
    }

    public void addData(JSONObject object_to_add) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        data.add(object_to_add);
        this.addData(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(List<JSONObject> data, JSONStoreAddOptions options) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_ADD);
        try {
            if (options == null) {
                options = new JSONStoreAddOptions();
            }
            if (data == null || data.size() <= 0) {
                return;
            }
            DatabaseAccessor acc = this.getAccessor();
            if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                acc.getRawDatabase().beginTransaction();
            }
            try {
                for (JSONObject data_to_add : data) {
                    if (data_to_add == null) continue;
                    Map<String, Object> mappedObj = null;
                    try {
                        mappedObj = this.schema.mapObject(data_to_add, options.getAdditionalSearchFieldsAsJSON());
                        mappedObj.put("json", data_to_add.toString());
                    }
                    catch (Throwable t) {
                        String message = "An internal error occurred when trying to store the JSONObject. Error mapping the search fields.";
                        JSONStoreAddException jsException = new JSONStoreAddException(message, t);
                        this.logger.logError(message, jsException);
                        throw jsException;
                    }
                    if (options.isMarkDirty()) {
                        mappedObj.put("_dirty", new Date().getTime());
                        mappedObj.put("_operation", "add");
                    } else {
                        mappedObj.put("_dirty", 0);
                        mappedObj.put("_operation", "store");
                    }
                    ContentValues contentValues = new ContentValues();
                    for (String key : mappedObj.keySet()) {
                        Object val = mappedObj.get(key);
                        if (val instanceof Boolean) {
                            val = (Boolean)val != false ? 1 : 0;
                        }
                        contentValues.put("'" + JSONStoreUtil.getDatabaseSafeSearchFieldName(key) + "'", val.toString());
                    }
                    long rc = acc.getRawDatabase().insert(this.getName(), null, contentValues);
                    if (rc != -1L) continue;
                    String message = "An internal error occurred when trying to insert a document.";
                    JSONStoreAddException jsException = new JSONStoreAddException(message);
                    this.logger.logError(message, jsException);
                    throw jsException;
                }
                if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                    acc.getRawDatabase().setTransactionSuccessful();
                }
            }
            finally {
                if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                    acc.getRawDatabase().endTransaction();
                }
            }
        }
        finally {
            logInst.end();
        }
    }

    public void addData(JSONObject object_to_add, JSONStoreAddOptions opts) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        data.add(object_to_add);
        this.addData(data, opts);
    }

    public void addData(List<JSONObject> object_to_add) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        this.addData(object_to_add, null);
    }

    public void addData(JSONArray dataArray) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        List<JSONObject> data = JSONStoreUtil.convertJSONArrayToJSONObjectList(dataArray);
        this.addData(data, null);
    }

    public void addData(JSONArray dataArray, JSONStoreAddOptions opts) throws JSONStoreAddException, JSONStoreDatabaseClosedException {
        List<JSONObject> data = JSONStoreUtil.convertJSONArrayToJSONObjectList(dataArray);
        this.addData(data, opts);
    }

    public int removeDocumentById(Integer id) throws JSONStoreRemoveException, JSONStoreDatabaseClosedException {
        return this.removeDocumentById(id, null);
    }

    public int removeDocumentById(Integer id, JSONStoreRemoveOptions options) throws JSONStoreRemoveException, JSONStoreDatabaseClosedException {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        list.add(id);
        return this.removeDocumentsById(list, options);
    }

    public int removeDocumentsById(List<Integer> document_ids) throws JSONStoreRemoveException, JSONStoreDatabaseClosedException {
        return this.removeDocumentsById(document_ids, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeDocumentsById(List<Integer> document_ids, JSONStoreRemoveOptions options) throws JSONStoreRemoveException, JSONStoreDatabaseClosedException {
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_REMOVE);
        try {
            DatabaseAccessor accessor = this.getAccessor();
            if (options == null) {
                options = new JSONStoreRemoveOptions();
            }
            List<Object> documents = new LinkedList();
            try {
                documents = this.findDocumentsById(document_ids);
            }
            catch (JSONStoreFindException e) {
                throw new JSONStoreRemoveException("Could not execute find on document ids", e);
            }
            LinkedList<JSONObject> failures = new LinkedList<JSONObject>();
            int removedCount = 0;
            if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                try {
                    accessor.getRawDatabase().beginTransaction();
                }
                catch (Throwable e) {
                    throw new JSONStoreRemoveException(e);
                }
            }
            for (JSONObject jSONObject : documents) {
                if (jSONObject == null) continue;
                try {
                    removedCount += accessor.getWritableDatabase().deleteIfRequired(jSONObject, !options.isMarkDirty(), true);
                }
                catch (Throwable e) {
                    String message = "Error while removing/deleting document in collection \"" + this.getName() + "\".";
                    this.logger.logTrace(message);
                    failures.add(jSONObject);
                    if (!this.initializedJSONStoreInstance.isTransactionInProgress()) continue;
                    try {
                        accessor.getRawDatabase().endTransaction();
                    }
                    catch (Throwable e1) {
                        throw new JSONStoreRemoveException(e1);
                    }
                }
            }
            if (failures.size() > 0) {
                if (this.initializedJSONStoreInstance.isTransactionInProgress()) {
                    try {
                        accessor.getRawDatabase().endTransaction();
                    }
                    catch (Throwable e1) {
                        throw new JSONStoreRemoveException(e1);
                    }
                }
                String message = "At least one document could not be removed.";
                JSONStoreRemoveException jSONStoreRemoveException = new JSONStoreRemoveException(message, failures);
                this.logger.logError(message, jSONStoreRemoveException);
                throw jSONStoreRemoveException;
            }
            if (!this.initializedJSONStoreInstance.isTransactionInProgress()) {
                try {
                    accessor.getRawDatabase().setTransactionSuccessful();
                    accessor.getRawDatabase().endTransaction();
                }
                catch (Throwable e1) {
                    throw new JSONStoreRemoveException(e1);
                }
            }
            int n = removedCount;
            return n;
        }
        finally {
            logInst.end();
        }
    }

    public int replaceDocument(JSONObject document) throws JSONStoreReplaceException, JSONStoreDatabaseClosedException {
        return this.replaceDocument(document, null);
    }

    public int replaceDocument(JSONObject document, JSONStoreReplaceOptions options) throws JSONStoreReplaceException, JSONStoreDatabaseClosedException {
        if (document == null) {
            return 0;
        }
        ArrayList<JSONObject> docList = new ArrayList<JSONObject>(1);
        docList.add(document);
        return this.replaceDocuments(docList, options);
    }

    public int replaceDocuments(List<JSONObject> documents) throws JSONStoreDatabaseClosedException, JSONStoreReplaceException {
        return this.replaceDocuments(documents, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceDocuments(List<JSONObject> documents, JSONStoreReplaceOptions options) throws JSONStoreDatabaseClosedException, JSONStoreReplaceException {
        int updatedDocs = 0;
        JSONStoreLogger.JSONStoreAnalyticsLogInstance logInst = JSONStoreLogger.startAnalyticsInstance(this.getUsername(), this.getName(), JSONStoreLogger.OPERATION_REPLACE);
        try {
            int n;
            if (documents == null) {
                int n2 = updatedDocs;
                return n2;
            }
            if (options == null) {
                options = new JSONStoreReplaceOptions();
            }
            DatabaseAccessor acc = this.getAccessor();
            LinkedList<JSONObject> failures = new LinkedList<JSONObject>();
            acc.getRawDatabase().beginTransaction();
            try {
                for (JSONObject document : documents) {
                    if (document == null) continue;
                    try {
                        ++updatedDocs;
                        acc.getWritableDatabase().update(document, !options.isMarkDirty());
                    }
                    catch (Throwable e) {
                        String message = "Error while updating document on collection \"" + this.schema.getName() + "\".";
                        this.logger.logTrace(message);
                        if (document == null) continue;
                        failures.add(document);
                    }
                }
                if (failures.size() != 0) {
                    String message = "At least one document failed to be replaced.";
                    JSONStoreReplaceException jsException = new JSONStoreReplaceException(message, failures);
                    this.logger.logError(message, jsException);
                    throw jsException;
                }
                acc.getRawDatabase().setTransactionSuccessful();
                n = updatedDocs;
            }
            catch (Throwable throwable) {
                acc.getRawDatabase().endTransaction();
                throw throwable;
            }
            acc.getRawDatabase().endTransaction();
            return n;
        }
        finally {
            logInst.end();
        }
    }
}

