/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreChangeOptions {
    private static final String REPLACE_CRITERIA_KEY = "replaceCriteria";
    private static final String MARK_DIRTY_KEY = "markDirty";
    private static final String ADD_NEW_KEY = "addNew";
    private List<String> searchFieldCriteria = new LinkedList<String>();
    private boolean markDirty = false;
    private boolean addNew = false;

    public JSONStoreChangeOptions() {
    }

    public JSONStoreChangeOptions(JSONObject js_options) throws JSONException {
        this();
        JSONArray replaceCrit;
        if (js_options == null) {
            return;
        }
        if (js_options.has(ADD_NEW_KEY)) {
            this.setAddNew(js_options.getBoolean(ADD_NEW_KEY));
        }
        if (js_options.has(MARK_DIRTY_KEY)) {
            this.setMarkDirty(js_options.getBoolean(MARK_DIRTY_KEY));
        }
        if (js_options.has(REPLACE_CRITERIA_KEY) && (replaceCrit = js_options.optJSONArray(REPLACE_CRITERIA_KEY)) != null) {
            for (int i = 0; i < replaceCrit.length(); ++i) {
                this.addSearchFieldToCriteria(replaceCrit.getString(i));
            }
        }
    }

    public void addSearchFieldToCriteria(String search_field) {
        if (search_field == null || search_field.isEmpty()) {
            throw new IllegalArgumentException("search_key parameter cannot be null or empty");
        }
        this.searchFieldCriteria.add(search_field);
    }

    public void setSearchFieldCriteria(List<String> search_fields) {
        this.searchFieldCriteria.clear();
        if (search_fields != null) {
            for (String searchField : search_fields) {
                this.addSearchFieldToCriteria(searchField);
            }
        }
    }

    public List<String> getSearchFieldCriteria() {
        return this.searchFieldCriteria;
    }

    public void setMarkDirty(boolean mark_dirty) {
        this.markDirty = mark_dirty;
    }

    public boolean isMarkDirty() {
        return this.markDirty;
    }

    public void setAddNew(boolean add_new) {
        this.addNew = add_new;
    }

    public boolean isAddNew() {
        return this.addNew;
    }
}

