/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.jsonstore.api;

import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStoreAddOptions {
    private static final String OPTION_ADDITIONAL_SEARCH_FIELDS = "additionalSearchFields";
    private static final String OPTION_IS_ADD = "isAdd";
    private JSONObject additionalSearchFields = new JSONObject();
    private boolean markDirty = false;

    public JSONStoreAddOptions() {
    }

    public JSONStoreAddOptions(JSONObject json) {
        this();
        if (json != null) {
            this.additionalSearchFields = json.optJSONObject(OPTION_ADDITIONAL_SEARCH_FIELDS);
            this.markDirty = json.optBoolean(OPTION_IS_ADD, false);
        }
    }

    private void putAdditionalSearchField(String key, Object value) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key parameter cannot be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value parameter cannot be null.");
        }
        if (!(value instanceof String || value instanceof Integer || value instanceof Number || value instanceof Boolean)) {
            throw new IllegalArgumentException("Value parameter must be a String, Integer, Number, or Boolean type.");
        }
        if (this.additionalSearchFields.has(key)) {
            this.additionalSearchFields.remove(key);
        }
        try {
            this.additionalSearchFields.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addAdditionalSearchFields(JSONObject additional_search_fields) {
        if (additional_search_fields == null) {
            additional_search_fields = new JSONObject();
        }
        Iterator jsonObjectKeys = additional_search_fields.keys();
        while (jsonObjectKeys.hasNext()) {
            String key = (String)jsonObjectKeys.next();
            Object val = null;
            try {
                val = additional_search_fields.get(key);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Error when adding additional search field. Could not get the value in JSONObject for search field '" + key + "'.", e);
            }
            this.putAdditionalSearchField(key, val);
        }
    }

    public void addAdditionalSearchFields(Map<String, Object> additional_search_fields) {
        for (String key : additional_search_fields.keySet()) {
            try {
                this.putAdditionalSearchField(key, additional_search_fields.get(key));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error when adding additional search field '" + key + "'.", e);
            }
        }
    }

    public void addAdditionalSearchField(String key, String value) throws IllegalArgumentException {
        this.putAdditionalSearchField(key, value);
    }

    public void addAdditionalSearchField(String key, Integer value) throws IllegalArgumentException {
        this.putAdditionalSearchField(key, value);
    }

    public void addAdditionalSearchField(String key, Number value) throws IllegalArgumentException {
        this.putAdditionalSearchField(key, value);
    }

    public void addAdditionalSearchField(String key, Boolean value) {
        this.putAdditionalSearchField(key, value);
    }

    public void setMarkDirty(boolean mark_dirty) {
        this.markDirty = mark_dirty;
    }

    public boolean isMarkDirty() {
        return this.markDirty;
    }

    public JSONObject getAdditionalSearchFieldsAsJSON() {
        return this.additionalSearchFields;
    }
}

