/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common.security;

import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.common.security.WLCertManager;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.HttpClientManager;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import org.json.JSONObject;

public class WLUserAuthManager
extends WLCertManager {
    private static Logger logger = Logger.getInstance("wl.userAuthManager");
    private static final String CERTIFICATE_ALIAS = "com.worklight.userenrollment.certificate";
    private static final String PROVISIONING_ENTITY = "";
    private static WLUserAuthManager instance;
    private static String KEYSTORE_FILENAME;
    private static char[] keyStorePassword;

    public static synchronized WLUserAuthManager getInstance() {
        if (instance == null) {
            instance = new WLUserAuthManager();
        }
        return instance;
    }

    private WLUserAuthManager() {
        super(KEYSTORE_FILENAME, keyStorePassword);
    }

    @Override
    protected String getAlias(String provisioningEntity) {
        String aliasPrefix = "com.worklight.userenrollment.certificate:";
        WLConfig.createInstance(this.context);
        WLConfig config = WLConfig.getInstance();
        if (config.isShareUserCert()) {
            logger.debug("Using group support alias for user certificate authentication realm.");
            return aliasPrefix + this.context.getApplicationInfo().uid;
        }
        return aliasPrefix + this.context.getPackageName();
    }

    public boolean doesValidCertificateExist() {
        try {
            KeyStore.PrivateKeyEntry pke = this.getPrivateKeyEntry(PROVISIONING_ENTITY);
            boolean certificateExists = pke != null;
            boolean certificateIsValid = true;
            if (certificateExists) {
                try {
                    ((X509Certificate)pke.getCertificate()).checkValidity();
                }
                catch (CertificateNotYetValidException e) {
                    logger.error("Certificate is not yet valid: " + e.getMessage());
                    certificateIsValid = false;
                }
                catch (CertificateExpiredException e) {
                    logger.error("Certificate has expired: " + e.getMessage());
                    certificateIsValid = false;
                }
            }
            pke = null;
            if (!certificateIsValid) {
                this.removeEntityKeyStoreValues(PROVISIONING_ENTITY);
                logger.debug("doesValidCertificateExists = false (Certificate not yet valid or expired)");
                return false;
            }
            logger.debug("doesValidCertificateExists = " + certificateExists);
            return certificateExists;
        }
        catch (Exception e) {
            logger.error("Failed to determine the existence of certificate for device authentication with " + e.getMessage(), e);
            return false;
        }
    }

    public JSONObject authenticateToTheServerWithCertificate() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        logger.debug("Establishing SSL connection with the server using the user certificate from the user certificate realm.");
        JSONObject httpsResult = new JSONObject();
        KeyStore keyStore = this.getCertificateKeyStore();
        HttpClientManager.setSSLSocketFactory(keyStore, keyStorePassword);
        String instanceId = WLConfig.getInstance().readWLPref("WL-Instance-Id");
        if (!WLUtils.isStringEmpty(instanceId)) {
            WLClient.getInstance().addGlobalHeader("WL-Instance-Id", instanceId);
        }
        WLRequestOptions options = new WLRequestOptions();
        WLRequestListener initRequestListener = new WLRequestListener(){

            @Override
            public void onSuccess(WLResponse wlResponse) {
            }

            @Override
            public void onFailure(WLFailResponse wlFailResponse) {
            }
        };
        WLRequest initRequest = new WLRequest(initRequestListener, options, WLConfig.getInstance(), this.context);
        initRequest.makeRequest("sslclientauth");
        return httpsResult;
    }

    private KeyStore getCertificateKeyStore() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        KeyStore keyStore = this.loadKeyStore();
        KeyManagerFactory keyManagerFactory = null;
        keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        return keyStore;
    }

    private KeyStore loadKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore myKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File myKeyStoreFile = new File(this.context.getFilesDir().getAbsolutePath() + "/" + KEYSTORE_FILENAME);
        FileInputStream myFis = null;
        if (myKeyStoreFile.exists()) {
            myFis = new FileInputStream(myKeyStoreFile);
            myKeyStore.load(myFis, keyStorePassword);
            return myKeyStore;
        }
        return null;
    }

    public void clearKeystore() throws KeyStoreException {
        this.clearKeystore(PROVISIONING_ENTITY);
    }

    public void saveCertificate(String certString, String realm) throws Exception {
        logger.debug("Saving certificate for user certificate authentication realm...");
        this.saveCertificate(PROVISIONING_ENTITY, certString, realm);
        logger.debug("Certificate saved for user certificate authentication realm.");
    }

    public KeyPair generateKeyPair(int rsaKeySize) throws NoSuchAlgorithmException {
        return this.generateKeyPair(PROVISIONING_ENTITY, rsaKeySize);
    }

    public String createSignedCSR(JSONObject csrJSON) throws Exception {
        return this.createSignedCSR(csrJSON, PROVISIONING_ENTITY);
    }

    static {
        KEYSTORE_FILENAME = ".x509Keystore";
        keyStorePassword = "worklight".toCharArray();
    }
}

